/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.jboolexpr;

import com.linkare.jboolexpr.BooleanAndOperation;
import com.linkare.jboolexpr.BooleanExpression;
import com.linkare.jboolexpr.BooleanNotOperation;
import com.linkare.jboolexpr.BooleanOrOperation;
import com.linkare.jboolexpr.BooleanUtil;
import com.linkare.jboolexpr.BooleanXorOperation;
import com.linkare.jboolexpr.IBoolean;
import com.linkare.jboolexpr.MalformedBooleanException;
import com.linkare.jboolexpr.SimpleBoolean;

public final class BooleanExpressionLR
extends BooleanExpression {
    private static final int FALSE_LENGTH = 5;
    private static final int TRUE_LENGTH = 4;
    private String booleanExpression;
    private IBoolean iBoolean;

    BooleanExpressionLR(String newBooleanExpression) throws MalformedBooleanException {
        this.booleanExpression = newBooleanExpression;
        this.iBoolean = this.toIBoolean(BooleanUtil.validAndformat(newBooleanExpression), newBooleanExpression.length());
    }

    @Override
    public boolean booleanValue() {
        return this.iBoolean.booleanValue();
    }

    private IBoolean toIBoolean(String formatedBooleanExpression, int index) throws MalformedBooleanException {
        int lastChar = this.getLastChar(formatedBooleanExpression);
        if (new Character((char)lastChar).toString().matches("\\s")) {
            lastChar = 32;
        }
        String substring = this.getSubstringWithoutLastChar(formatedBooleanExpression);
        switch (lastChar) {
            case 32: {
                return this.toIBoolean(substring, index - 1);
            }
            case 41: {
                String openToEnd = this.getFromOpenParenthesisToEnd(substring, index - 1);
                String beginToOpen = this.getFromBeginToOpenParenthesis(substring, index - 1);
                IBoolean boolOpenToEnd = this.toIBoolean(openToEnd, index - 1);
                return this.toIBoolean(boolOpenToEnd, beginToOpen, index - 1);
            }
            case 84: {
                return this.toIBoolean(new SimpleBoolean(true), substring, index - 4);
            }
            case 70: {
                return this.toIBoolean(new SimpleBoolean(false), substring, index - 5);
            }
        }
        throw new MalformedBooleanException("Expected [ ' ', ), true, false ]", index, this.booleanExpression);
    }

    private IBoolean toIBoolean(IBoolean lastIBoolean, String formatedBooleanExpression, int index) throws MalformedBooleanException {
        int lastChar = this.getLastChar(formatedBooleanExpression);
        if (new Character((char)lastChar).toString().matches("\\s")) {
            lastChar = 32;
        }
        String substring = this.getSubstringWithoutLastChar(formatedBooleanExpression);
        switch (lastChar) {
            case 32: {
                return this.toIBoolean(lastIBoolean, substring, index - 1);
            }
            case 46: {
                return lastIBoolean;
            }
            case 40: {
                return this.toIBoolean(lastIBoolean, substring, index - 1);
            }
            case 124: {
                IBoolean boolFirstOr = this.toIBoolean(substring, index - 2);
                return new BooleanOrOperation(boolFirstOr, lastIBoolean);
            }
            case 38: {
                IBoolean boolFirstAnd = this.toIBoolean(substring, index - 2);
                return new BooleanAndOperation(boolFirstAnd, lastIBoolean);
            }
            case 33: {
                BooleanNotOperation boolNot = new BooleanNotOperation(lastIBoolean);
                return this.toIBoolean(boolNot, substring, index - 1);
            }
            case 94: {
                IBoolean boolFirstXor = this.toIBoolean(substring, index - 1);
                return new BooleanXorOperation(boolFirstXor, lastIBoolean);
            }
        }
        throw new MalformedBooleanException("Expected [ ' ', ), ||, &&, !, ^ ]", index, this.booleanExpression);
    }

    private char getLastChar(String formatedBooleanExpression) {
        if (formatedBooleanExpression.length() == 0) {
            return '.';
        }
        return formatedBooleanExpression.charAt(formatedBooleanExpression.length() - 1);
    }

    private String getSubstringWithoutLastChar(String formatedBooleanExpression) {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        return formatedBooleanExpression.substring(0, formatedBooleanExpression.length() - 1);
    }

    private String getFromBeginToOpenParenthesis(String formatedBooleanExpression, int index) throws MalformedBooleanException {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        int fromIndex = 0;
        int toIndex = this.getIndexOfOpenParenthesis(formatedBooleanExpression, index);
        return formatedBooleanExpression.substring(fromIndex, toIndex);
    }

    private String getFromOpenParenthesisToEnd(String formatedBooleanExpression, int index) throws MalformedBooleanException {
        if (formatedBooleanExpression == null || formatedBooleanExpression.length() == 0) {
            return "";
        }
        int fromIndex = this.getIndexOfOpenParenthesis(formatedBooleanExpression, index) + 1;
        int toIndex = formatedBooleanExpression.length();
        return formatedBooleanExpression.substring(fromIndex, toIndex);
    }

    private int getIndexOfOpenParenthesis(String formatedBooleanExpression, int index) throws MalformedBooleanException {
        int lastIndexOfOpenParenthesis = this.getLastIndexOf(formatedBooleanExpression, "(", formatedBooleanExpression.length());
        int lastIndexOfCloseParenthesis = this.getLastIndexOf(formatedBooleanExpression, ")", formatedBooleanExpression.length());
        while (lastIndexOfCloseParenthesis != -1 && lastIndexOfOpenParenthesis < lastIndexOfCloseParenthesis) {
            lastIndexOfOpenParenthesis = this.getLastIndexOf(formatedBooleanExpression, "(", lastIndexOfOpenParenthesis);
            lastIndexOfCloseParenthesis = this.getLastIndexOf(formatedBooleanExpression, ")", lastIndexOfCloseParenthesis);
        }
        if (lastIndexOfOpenParenthesis == -1) {
            int parenthesisIndex = index - (formatedBooleanExpression.length() - lastIndexOfCloseParenthesis);
            throw new MalformedBooleanException("Have a close parenthesis without an open parenthesis", parenthesisIndex, this.booleanExpression);
        }
        return lastIndexOfOpenParenthesis;
    }

    private int getLastIndexOf(String formatedBooleanExpression, String searchedString, int toIndex) {
        if (toIndex < 0) {
            return -1;
        }
        if (toIndex >= formatedBooleanExpression.length()) {
            return formatedBooleanExpression.lastIndexOf(searchedString);
        }
        String newFormatedBooleanExpression = formatedBooleanExpression.substring(0, toIndex);
        return newFormatedBooleanExpression.lastIndexOf(searchedString);
    }

    public String toString() {
        return this.iBoolean.toString();
    }
}

