package com.linkare.commons.jpa;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

import com.linkare.commons.utils.EqualityUtils;

/**
 * This class may be used in any client project where persistent entities need an auto increment id of type long.
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 */
@MappedSuperclass
public abstract class DefaultDomainObject extends DomainObject implements Comparable<DefaultDomainObject> {

    private static final long serialVersionUID = 1L;

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(insertable = false, updatable = false, name = "id", nullable = false, unique = true)
    private Long idInternal;

    /**
     * 
     */
    public DefaultDomainObject() {
	super();
    }

    /**
     * @return the idInternal
     */
    public Long getIdInternal() {
	return idInternal;
    }

    /**
     * @param idInternal
     *            the idInternal to set
     */
    public void setIdInternal(Long idInternal) {
	this.idInternal = idInternal;
    }

    @Override
    public boolean equals(final Object other) {
	if (this == other) {
	    return true;
	}
	if (!(other instanceof DefaultDomainObject)) {
	    return false;
	}
	return equalsTo((DefaultDomainObject) other);
    }

    @Override
    public int hashCode() {
	int result = 14;
	result = 29 * result + (getIdInternal() != null ? getIdInternal().hashCode() : 0);
	return result;
    }

    private boolean equalsTo(final DefaultDomainObject other) {
	if (getIdInternal() == null && other.getIdInternal() == null) {
	    return false;
	}
	return EqualityUtils.equals(getIdInternal(), other.getIdInternal());
    }

    @Override
    public String toString() {
	return getClass() + "(" + getIdInternal() + ")";
    }

    @Override
    public Long id() {
	return getIdInternal();
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    @Override
    public int compareTo(DefaultDomainObject other) {
	if (EqualityUtils.equals(getIdInternal(), other.getIdInternal())) {
	    return 0;
	}
	if (getIdInternal() == null && other.getIdInternal() != null) {
	    return -other.getIdInternal().intValue();
	}
	if (getIdInternal() != null && other.getIdInternal() == null) {
	    return getIdInternal().intValue();
	}
	return getIdInternal().compareTo(other.getIdInternal());
    }
}