package com.linkare.commons.jpa.audit;

import java.util.Calendar;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import com.linkare.commons.jpa.DefaultDomainObject;

/**
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 */
// TODO: Add date field, for the situations where the same object is changed in the same operation...
@Entity
@Table(name = "audit_operation")
public class AuditOperation extends DefaultDomainObject {

    private static final long serialVersionUID = 1L;

    @JoinColumn(name = "key_auditor")
    @ManyToOne(fetch = FetchType.LAZY)
    private Auditor auditor;

    @JoinColumn(name = "key_audited")
    @ManyToOne(fetch = FetchType.EAGER)
    private AuditedObject audited;

    @Enumerated(EnumType.STRING)
    @Column(name = "operation")
    private Operation operation;

    @Column(name = "value")
    @Basic
    @Lob
    private String value;

    @Column(name = "instant")
    @Temporal(TemporalType.TIMESTAMP)
    private Calendar instant;

    private AuditOperation() {
	super();
    }

    public AuditOperation(final Auditor auditor, final AuditedObject audited, final Operation operation) {
	this(auditor, audited, operation, audited == null ? null : audited.serializeToLog());
    }

    public AuditOperation(Auditor auditor, AuditedObject audited, Operation operation, final String value) {
	this();
	this.auditor = auditor;
	this.audited = audited;
	this.operation = operation;
	this.value = value;
	this.instant = Calendar.getInstance();
    }

    /**
     * @return the auditor
     */
    public Auditor getAuditor() {
	return auditor;
    }

    /**
     * @param auditor
     *            the auditor to set
     */
    public void setAuditor(Auditor auditor) {
	this.auditor = auditor;
    }

    /**
     * @return the audited
     */
    public AuditedObject getAudited() {
	return audited;
    }

    /**
     * @param audited
     *            the audited to set
     */
    public void setAudited(AuditedObject audited) {
	this.audited = audited;
    }

    /**
     * @return the operation
     */
    public Operation getOperation() {
	return operation;
    }

    /**
     * @param operation
     *            the operation to set
     */
    public void setOperation(Operation operation) {
	this.operation = operation;
    }

    /**
     * @return the value
     */
    public String getValue() {
	return value;
    }

    /**
     * @param value
     *            the value to set
     */
    public void setValue(String value) {
	this.value = value;
    }

    /**
     * @return the instant
     */
    public Calendar getInstant() {
	return instant;
    }

    /**
     * @param instant
     *            the instant to set
     */
    public void setInstant(Calendar instant) {
	this.instant = instant;
    }
}