package com.linkare.commons.jpa.audit;

import java.util.Date;
import java.util.List;

// TODO: Use JodaTime
/**
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 */
public interface Auditable {

    public Auditor getCreationAuditor();

    public Auditor getLastUpdateAuditor();

    public Auditor getRemoveAuditor();

    public List<Auditor> getAllAuditors();

    /**
     * 
     * @return Returns an ordered list by date of all modifiers of a given audited entity. It cannot be a Set, since it must allow duplicated modifiers.
     */
    public List<String> getAllModifiers();

    public String getCreator();

    public Date getCreationDate();

    public String getLastModifier();

    public Date getLastModificationDate();

    public String getRemover();

    public Date getRemoveDate();
}