package com.linkare.commons.jpa.audit;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlAttribute;

import com.linkare.commons.jpa.DefaultDomainObject;

/**
 * Each instance of this object may be shared by any other objects, so that they all refer to the same audit moment.
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 */
@Entity
@Inheritance(strategy = InheritanceType.SINGLE_TABLE)
@Table(name = "auditor")
public class Auditor extends DefaultDomainObject {

    private static final long serialVersionUID = 1L;

    /**
     * The entity that was performing the operation
     */
    @XmlAttribute
    @Basic(optional = false)
    @Column(name = "performed_by")
    private String performedBy;

    /**
     * The date this entity was created
     */
    @XmlAttribute
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "operation_date")
    private Date operationDate;

    @Column(name = "generic_operation")
    private String genericOperation;

    /**
     * The objects that are audited by this auditor.
     */
    @OneToMany(fetch = FetchType.EAGER, mappedBy = "auditor")
    private List<AuditOperation> auditOperations;

    private Auditor() {
	super();
    }

    /**
     * 
     * @param genericOperation
     * @param performedBy
     * @param operationDate
     */
    public Auditor(final String genericOperation, final String performedBy, final Date operationDate) {
	this(genericOperation, performedBy, operationDate, null);
    }

    /**
     * 
     * @param genericOperation
     * @param performedBy
     * @param operationDate
     * @param auditOperations
     */
    public Auditor(final String genericOperation, final String performedBy, final Date operationDate, final List<AuditOperation> auditOperations) {
	this();
	this.genericOperation = genericOperation;
	this.performedBy = performedBy;
	this.operationDate = operationDate;
	this.auditOperations = auditOperations;
    }

    /**
     * @return the performedBy
     */
    public String getPerformedBy() {
	return performedBy;
    }

    /**
     * @param performedBy
     *            the performedBy to set
     */
    public void setPerformedBy(String performedBy) {
	this.performedBy = performedBy;
    }

    /**
     * @return the createdAt
     */
    public Date getOperationDate() {
	return operationDate;
    }

    /**
     * @param createdAt
     *            the createdAt to set
     */
    public void setOperationDate(Date createdAt) {
	this.operationDate = createdAt;
    }

    /**
     * @return the auditOperations
     */
    public List<AuditOperation> getAuditOperations() {
	return auditOperations;
    }

    /**
     * @param auditOperations
     *            the auditOperations to set
     */
    public void setAuditOperations(List<AuditOperation> auditOperations) {
	this.auditOperations = auditOperations;
    }

    /**
     * @return the genericOperation
     */
    public String getGenericOperation() {
	return genericOperation;
    }

    /**
     * @param genericOperation
     *            the genericOperation to set
     */
    public void setGenericOperation(String genericOperation) {
	this.genericOperation = genericOperation;
    }

    /**
     * 
     * @return Returns the list of all objects that were audited by this auditor instance.
     */
    public List<AuditedObject> getAuditedObjects() {
	final List<AuditedObject> result = new ArrayList<AuditedObject>();
	for (final AuditOperation auditOperation : getAuditOperations()) {
	    result.add(auditOperation.getAudited());
	}
	return result;
    }
}