package com.linkare.commons.jpa.logging;

import java.util.ArrayList;
import java.util.List;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import com.linkare.commons.jpa.DefaultDomainObject;

/**
 * This object is used to keep the historic of a given domain object.
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 */
@Entity
@Table(name = "domain_object_log")
public class DomainObjectLog extends DefaultDomainObject {

    private static final long serialVersionUID = 1L;

    @JoinColumn(name = "key_domain_object")
    @OneToOne(fetch = FetchType.EAGER)
    private LoggedDomainObject loggedDomainObject;

    @Column(name = "value")
    private String value;

    @OneToMany(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    private List<DomainObjectLogEntry> logEntries;

    private DomainObjectLog() {
	super();
    }

    public DomainObjectLog(final LoggedDomainObject value) {
	this(value, value == null ? null : value.serializeToLog());
    }

    private DomainObjectLog(final LoggedDomainObject loggedDomainObject, String value) {
	this();
	this.loggedDomainObject = loggedDomainObject;
	this.value = value;
    }

    /**
     * @return the loggedDomainObject
     */
    public LoggedDomainObject getLoggedDomainObject() {
	return loggedDomainObject;
    }

    /**
     * @param loggedDomainObject
     *            the loggedDomainObject to set
     */
    public void setLoggedDomainObject(final LoggedDomainObject loggedDomainObject) {
	this.loggedDomainObject = loggedDomainObject;
    }

    /**
     * @return the logEntries
     */
    public List<DomainObjectLogEntry> getLogEntries() {
	return logEntries;
    }

    /**
     * @param logEntries
     *            the logEntries to set
     */
    public void setLogEntries(List<DomainObjectLogEntry> logEntries) {
	this.logEntries = logEntries;
    }

    /**
     * @return the value
     */
    public final String getValue() {
	return value;
    }

    /**
     * @param value
     *            the value to set
     */
    public final void setValue(String value) {
	this.value = value;
    }

    /**
     * 
     * @param logEntry
     */
    public void addEntry(final DomainObjectLogEntry logEntry) {
	if (this.logEntries == null) {
	    this.logEntries = new ArrayList<DomainObjectLogEntry>();
	}
	this.logEntries.add(logEntry);
    }

    /**
     * 
     * @param logEntry
     */
    public void removeEntry(final DomainObjectLogEntry logEntry) {
	if (this.logEntries == null) {
	    return;
	}
	this.logEntries.remove(logEntry);
    }
}