package com.linkare.commons.jpa.logging;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.linkare.commons.jpa.DefaultDomainObject;

/**
 * This object is used to keep the historic of a given domain object.
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 */
@Entity
@Table(name = "domain_object_log_entry")
public class DomainObjectLogEntry extends DefaultDomainObject {

    private static final long serialVersionUID = 1L;

    @JoinColumn(name = "key_log")
    @ManyToOne(fetch = FetchType.EAGER)
    private DomainObjectLog log;

    @Column(name = "value")
    @Basic
    @Lob
    private String value;

    private DomainObjectLogEntry() {
	super();
    }

    public DomainObjectLogEntry(final DomainObjectLog log, final LoggedDomainObject value) {
	this(log, value == null ? null : value.serializeToLog());
    }

    private DomainObjectLogEntry(final DomainObjectLog log, String value) {
	this();
	this.log = log;
	this.value = value;
    }

    /**
     * @return the log
     */
    public DomainObjectLog getLog() {
	return log;
    }

    /**
     * @param log
     *            the log to set
     */
    public void setLog(DomainObjectLog log) {
	this.log = log;
    }

    /**
     * @return the value
     */
    public String getValue() {
	return value;
    }

    /**
     * @param value
     *            the value to set
     */
    public void setValue(String value) {
	this.value = value;
    }
}