package com.linkare.commons.jpa.logging;

import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Table;

import com.linkare.commons.jpa.DefaultDomainObject;
import com.linkare.commons.jpa.utils.EntityManagerLocator;

/**
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 */
@Entity
@Table(name = "logged_domain_object")
public class LoggedDomainObject extends DefaultDomainObject {

    private static final long serialVersionUID = 1L;

    @OneToOne(fetch = FetchType.LAZY, mappedBy = "loggedDomainObject")
    private DomainObjectLog log;

    public LoggedDomainObject() {
	super();
    }

    /**
     * @return the log
     */
    public DomainObjectLog getLog() {
	return log;
    }

    /**
     * @param log
     *            the log to set
     */
    public void setLog(DomainObjectLog log) {
	this.log = log;
    }

    private void addLog() {
	final EntityManager em = EntityManagerLocator.getCurrentEntityManager();
	DomainObjectLog newLog = getLog();
	if (newLog == null) {
	    newLog = new DomainObjectLog(this);
	}
	newLog.addEntry(new DomainObjectLogEntry(newLog, this));
	em.persist(newLog);
    }

    @PrePersist
    @Override
    public void prePersist() {
	super.prePersist();
	addLog();
    }

    @PreUpdate
    @Override
    public void preUpdate() {
	super.preUpdate();
	addLog();
    }

    @PreRemove
    @Override
    public void preRemove() {
	super.preRemove();
	addLog();
    }
}