package com.linkare.commons.jpa.utils;

import javax.persistence.EntityManager;

/**
 * 
 * @author Paulo Zenida - Linkare TI
 * 
 */
public final class EntityManagerLocator {

    private static InheritableThreadLocal<EntityManager> entityManagerRegistry = new InheritableThreadLocal<EntityManager>();

    private EntityManagerLocator() {
    }

    public static EntityManager getCurrentEntityManager() {
	return entityManagerRegistry.get();
    }

    public static void setCurrentEntityManager(final EntityManager em) {
	entityManagerRegistry.set(em);
    }
}