/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.commons.dao.jpa;

import com.linkare.commons.dao.Deletable;
import com.linkare.commons.dao.IGenericDAO;
import com.linkare.commons.dao.Identifiable;
import com.linkare.commons.jpa.exceptions.DomainException;
import com.linkare.commons.utils.BooleanResult;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;

public abstract class GenericDAO<T extends Identifiable<ID> & Deletable, ID extends Serializable>
implements IGenericDAO<T, ID> {
    private static final String FIND_ALL_QUERY = ".findAll";
    private static final String COUNT_ALL_QUERY = ".countAll";
    private EntityManager entityManager;
    private Class<T> entityTypeClass;

    public GenericDAO(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public final EntityManager getEntityManager() {
        return this.entityManager;
    }

    public final void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void create(T t) {
        BooleanResult operationResult = this.canCreate(t);
        if (Boolean.TRUE != operationResult.getResult()) {
            throw new DomainException(operationResult.getMessage());
        }
        this.getEntityManager().persist(t);
    }

    protected BooleanResult canCreate(T t) {
        return BooleanResult.TRUE_RESULT;
    }

    public T edit(T t) {
        BooleanResult operationResult = this.canEdit(t);
        if (Boolean.TRUE == operationResult.getResult()) {
            return (T)((Identifiable)this.getEntityManager().merge(t));
        }
        throw new DomainException(operationResult.getMessage());
    }

    protected BooleanResult canEdit(T t) {
        return BooleanResult.TRUE_RESULT;
    }

    public void remove(T t) {
        BooleanResult operationResult = this.canRemove(t);
        if (Boolean.TRUE == operationResult.getResult()) {
            Identifiable mergedEntity = (Identifiable)this.getEntityManager().merge(t);
            if (((Deletable)mergedEntity).delete()) {
                this.getEntityManager().remove((Object)mergedEntity);
            }
        } else {
            throw new DomainException(operationResult.getMessage());
        }
    }

    protected BooleanResult canRemove(T t) {
        return BooleanResult.TRUE_RESULT;
    }

    public T find(ID id) {
        try {
            return (T)((Identifiable)this.getEntityManager().find(this.getEntityTypeClass(), id));
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public Query findAllQuery() {
        return this.getEntityManager().createNamedQuery(this.getEntityTypeName() + FIND_ALL_QUERY);
    }

    public Query countAllQuery() {
        return this.getEntityManager().createNamedQuery(this.getEntityTypeName() + COUNT_ALL_QUERY);
    }

    public final List<T> find(boolean all, int firstResult, int maxResults) {
        Query q = this.findAllQuery();
        if (!all) {
            q.setMaxResults(maxResults);
            q.setFirstResult(firstResult);
        }
        return q.getResultList();
    }

    public final List<T> findRange(int[] range) {
        return this.find(false, range[0], range[1]);
    }

    public final List<T> findAll() {
        return this.find(true, -1, -1);
    }

    public final int count() {
        Query query = this.countAllQuery();
        return ((Long)query.getSingleResult()).intValue();
    }

    private void initGenericType() {
        if (this.entityTypeClass == null) {
            ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
            this.entityTypeClass = (Class)parameterizedType.getActualTypeArguments()[0];
        }
    }

    private Class<T> getEntityTypeClass() {
        this.initGenericType();
        return this.entityTypeClass;
    }

    private String getEntityTypeName() {
        return this.getEntityTypeClass().getSimpleName();
    }
}

