/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.commons.jpa;

import com.linkare.commons.dao.Deletable;
import com.linkare.commons.dao.Identifiable;
import com.linkare.commons.jpa.Loggable;
import com.linkare.commons.jpa.exceptions.DomainException;
import com.linkare.commons.jpa.utils.EntityManagerLocator;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.MappedSuperclass;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@MappedSuperclass
@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class DomainObject
implements Serializable,
Identifiable<Long>,
Deletable,
Loggable {
    private static final long serialVersionUID = 1L;
    @Version
    @Column(name="version")
    private Integer version = 1;

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public static <Pk extends Serializable> DomainObject getById(Class<? extends DomainObject> objectClass, Pk id) {
        EntityManager em = EntityManagerLocator.getCurrentEntityManager();
        if (em == null) {
            throw new DomainException("error.no.entitymanager.found");
        }
        return (DomainObject)em.find(objectClass, id);
    }

    @PrePersist
    public void prePersist() {
    }

    @PreUpdate
    public void preUpdate() {
    }

    @PreRemove
    public void preRemove() {
    }

    @Override
    public String serializeToLog() {
        Object result = "";
        for (Field field : this.getClass().getDeclaredFields()) {
            if (this.shouldIgnoreField(field)) continue;
            boolean isAccessible = field.isAccessible();
            field.setAccessible(true);
            try {
                result = (String)result + field.getName() + "=" + field.get(this) + ",";
            }
            catch (Exception e) {
                result = (String)result + field.getName() + "=" + e.toString();
            }
            field.setAccessible(isAccessible);
        }
        return ((String)result).endsWith(",") ? ((String)result).substring(0, ((String)result).length() - 1) : result;
    }

    private boolean shouldIgnoreField(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public boolean isDeletable() {
        return true;
    }

    public boolean delete() {
        return true;
    }

    public boolean isPersistent() {
        return this.id() != null;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();
}

