/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.commons.jpa.audit;

import com.linkare.commons.jpa.DefaultDomainObject;
import com.linkare.commons.jpa.audit.AuditedObject;
import com.linkare.commons.jpa.audit.Auditor;
import com.linkare.commons.jpa.audit.Operation;
import java.util.Calendar;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="audit_operation")
public class AuditOperation
extends DefaultDomainObject {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="key_auditor")
    @ManyToOne(fetch=FetchType.LAZY)
    private Auditor auditor;
    @JoinColumn(name="key_audited")
    @ManyToOne(fetch=FetchType.EAGER)
    private AuditedObject audited;
    @Enumerated(value=EnumType.STRING)
    @Column(name="operation")
    private Operation operation;
    @Column(name="value")
    @Basic
    @Lob
    private String value;
    @Column(name="instant")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Calendar instant;

    private AuditOperation() {
    }

    public AuditOperation(Auditor auditor, AuditedObject audited, Operation operation) {
        this(auditor, audited, operation, audited == null ? null : audited.serializeToLog());
    }

    public AuditOperation(Auditor auditor, AuditedObject audited, Operation operation, String value) {
        this();
        this.auditor = auditor;
        this.audited = audited;
        this.operation = operation;
        this.value = value;
        this.instant = Calendar.getInstance();
    }

    public Auditor getAuditor() {
        return this.auditor;
    }

    public void setAuditor(Auditor auditor) {
        this.auditor = auditor;
    }

    public AuditedObject getAudited() {
        return this.audited;
    }

    public void setAudited(AuditedObject audited) {
        this.audited = audited;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Calendar getInstant() {
        return this.instant;
    }

    public void setInstant(Calendar instant) {
        this.instant = instant;
    }
}

