/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.commons.jpa.audit;

import com.linkare.commons.jpa.DefaultDomainObject;
import com.linkare.commons.jpa.audit.AuditOperation;
import com.linkare.commons.jpa.audit.Auditable;
import com.linkare.commons.jpa.audit.Auditor;
import com.linkare.commons.jpa.audit.Operation;
import com.linkare.commons.jpa.audit.utils.AuditorLocator;
import com.linkare.commons.jpa.exceptions.DomainException;
import com.linkare.commons.jpa.utils.EntityManagerLocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Query;
import javax.persistence.Table;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="audited_object")
@NamedQueries(value={@NamedQuery(name="AuditedObject.findAllAuditors", query="Select auditor from Auditor auditor, AuditOperation operation, AuditedObject audited where operation.auditor = auditor and operation.audited = audited order by auditor.operationDate"), @NamedQuery(name="AuditedObject.findAllAuditorsByOperation", query="Select auditor from Auditor auditor, AuditOperation operation, AuditedObject audited where operation.auditor = auditor and operation.audited = audited and operation.operation = :operation order by auditor.operationDate"), @NamedQuery(name="AuditedObject.findAllAuditorsByOperationDesc", query="Select auditor from Auditor auditor, AuditOperation operation, AuditedObject audited where operation.auditor = auditor and operation.audited = audited and operation.operation = :operation order by auditor.operationDate desc")})
public abstract class AuditedObject
extends DefaultDomainObject
implements Auditable {
    private static final long serialVersionUID = 1L;
    @OrderBy(value="auditor")
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="audited")
    private List<AuditOperation> auditOperations;

    public final List<AuditOperation> getAuditOperations() {
        return Collections.unmodifiableList(this.auditOperations);
    }

    private void addAuditOperation(AuditOperation auditOperation) {
        if (this.auditOperations == null) {
            this.auditOperations = new ArrayList<AuditOperation>();
        }
        this.auditOperations.add(auditOperation);
    }

    private void removeAuditOperation(AuditOperation auditOperation) {
        if (this.auditOperations == null) {
            return;
        }
        this.auditOperations.remove(auditOperation);
    }

    private void addAuditOperation(Operation operation) {
        EntityManager em = EntityManagerLocator.getCurrentEntityManager();
        Auditor currentAuditor = AuditorLocator.getCurrentAuditor();
        AuditOperation auditOperation = new AuditOperation(currentAuditor, this, operation);
        em.persist((Object)auditOperation);
        this.addAuditOperation(auditOperation);
    }

    @Override
    @PrePersist
    public final void prePersist() {
        super.prePersist();
        this.addAuditOperation(Operation.CREATE);
    }

    @Override
    @PreUpdate
    public final void preUpdate() {
        super.preUpdate();
        this.addAuditOperation(Operation.UPDATE);
    }

    @Override
    @PreRemove
    public final void preRemove() {
        super.preRemove();
        this.addAuditOperation(Operation.REMOVE);
    }

    @Override
    public final Auditor getCreationAuditor() {
        Auditor auditor = AuditedObject.findAllAuditorsByOperationDesc(Operation.CREATE);
        if (auditor == null) {
            throw new DomainException("error.no.auditor.found.for.audited.object");
        }
        return auditor;
    }

    @Override
    public final Auditor getLastUpdateAuditor() {
        return AuditedObject.findAllAuditorsByOperationDesc(Operation.UPDATE);
    }

    @Override
    public final Auditor getRemoveAuditor() {
        return AuditedObject.findAllAuditorsByOperationDesc(Operation.REMOVE);
    }

    @Override
    public final List<Auditor> getAllAuditors() {
        return AuditedObject.findAllAuditors();
    }

    @Override
    public final List<String> getAllModifiers() {
        List<Auditor> updateAuditors = AuditedObject.findAllAuditorsByOperation(Operation.UPDATE);
        if (updateAuditors == null || updateAuditors.isEmpty()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(updateAuditors.size());
        for (Auditor auditor : updateAuditors) {
            result.add(auditor.getPerformedBy());
        }
        return result;
    }

    @Override
    public final Date getCreationDate() {
        Auditor creationAuditor = this.getCreationAuditor();
        return creationAuditor == null ? null : creationAuditor.getOperationDate();
    }

    @Override
    public final String getCreator() {
        Auditor creationAuditor = this.getCreationAuditor();
        return creationAuditor == null ? null : creationAuditor.getPerformedBy();
    }

    @Override
    public final Date getLastModificationDate() {
        Auditor lastUpdateAuditor = this.getLastUpdateAuditor();
        return lastUpdateAuditor == null ? null : lastUpdateAuditor.getOperationDate();
    }

    @Override
    public final String getLastModifier() {
        Auditor lastUpdateAuditor = this.getLastUpdateAuditor();
        return lastUpdateAuditor == null ? null : lastUpdateAuditor.getPerformedBy();
    }

    @Override
    public final Date getRemoveDate() {
        Auditor removeAuditor = this.getRemoveAuditor();
        return removeAuditor == null ? null : removeAuditor.getOperationDate();
    }

    @Override
    public final String getRemover() {
        Auditor removeAuditor = this.getRemoveAuditor();
        return removeAuditor == null ? null : removeAuditor.getPerformedBy();
    }

    public static final List<Auditor> findAllAuditors() {
        EntityManager em = EntityManagerLocator.getCurrentEntityManager();
        Query query = em.createNamedQuery("AuditedObject.findAllAuditors");
        return query.getResultList();
    }

    public static final List<Auditor> findAllAuditorsByOperation(Operation operation) {
        EntityManager em = EntityManagerLocator.getCurrentEntityManager();
        Query query = em.createNamedQuery("AuditedObject.findAllAuditorsByOperation");
        query.setParameter("operation", (Object)operation);
        return query.getResultList();
    }

    public static final Auditor findAllAuditorsByOperationDesc(Operation operation) {
        EntityManager em = EntityManagerLocator.getCurrentEntityManager();
        Query query = em.createNamedQuery("AuditedObject.findAllAuditorsByOperationDesc");
        query.setMaxResults(1);
        query.setParameter("operation", (Object)operation);
        return (Auditor)query.getSingleResult();
    }
}

