/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.commons.jpa.audit;

import com.linkare.commons.jpa.DefaultDomainObject;
import com.linkare.commons.jpa.audit.AuditOperation;
import com.linkare.commons.jpa.audit.AuditedObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlAttribute;

@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@Table(name="auditor")
public class Auditor
extends DefaultDomainObject {
    private static final long serialVersionUID = 1L;
    @XmlAttribute
    @Basic(optional=false)
    @Column(name="performed_by")
    private String performedBy;
    @XmlAttribute
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="operation_date")
    private Date operationDate;
    @Column(name="generic_operation")
    private String genericOperation;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="auditor")
    private List<AuditOperation> auditOperations;

    private Auditor() {
    }

    public Auditor(String genericOperation, String performedBy, Date operationDate) {
        this(genericOperation, performedBy, operationDate, null);
    }

    public Auditor(String genericOperation, String performedBy, Date operationDate, List<AuditOperation> auditOperations) {
        this();
        this.genericOperation = genericOperation;
        this.performedBy = performedBy;
        this.operationDate = operationDate;
        this.auditOperations = auditOperations;
    }

    public String getPerformedBy() {
        return this.performedBy;
    }

    public void setPerformedBy(String performedBy) {
        this.performedBy = performedBy;
    }

    public Date getOperationDate() {
        return this.operationDate;
    }

    public void setOperationDate(Date createdAt) {
        this.operationDate = createdAt;
    }

    public List<AuditOperation> getAuditOperations() {
        return this.auditOperations;
    }

    public void setAuditOperations(List<AuditOperation> auditOperations) {
        this.auditOperations = auditOperations;
    }

    public String getGenericOperation() {
        return this.genericOperation;
    }

    public void setGenericOperation(String genericOperation) {
        this.genericOperation = genericOperation;
    }

    public List<AuditedObject> getAuditedObjects() {
        ArrayList<AuditedObject> result = new ArrayList<AuditedObject>();
        for (AuditOperation auditOperation : this.getAuditOperations()) {
            result.add(auditOperation.getAudited());
        }
        return result;
    }
}

