/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.commons.jpa.logging;

import com.linkare.commons.jpa.DefaultDomainObject;
import com.linkare.commons.jpa.logging.DomainObjectLogEntry;
import com.linkare.commons.jpa.logging.LoggedDomainObject;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="domain_object_log")
public class DomainObjectLog
extends DefaultDomainObject {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="key_domain_object")
    @OneToOne(fetch=FetchType.EAGER)
    private LoggedDomainObject loggedDomainObject;
    @Column(name="value")
    private String value;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<DomainObjectLogEntry> logEntries;

    private DomainObjectLog() {
    }

    public DomainObjectLog(LoggedDomainObject value) {
        this(value, value == null ? null : value.serializeToLog());
    }

    private DomainObjectLog(LoggedDomainObject loggedDomainObject, String value) {
        this();
        this.loggedDomainObject = loggedDomainObject;
        this.value = value;
    }

    public LoggedDomainObject getLoggedDomainObject() {
        return this.loggedDomainObject;
    }

    public void setLoggedDomainObject(LoggedDomainObject loggedDomainObject) {
        this.loggedDomainObject = loggedDomainObject;
    }

    public List<DomainObjectLogEntry> getLogEntries() {
        return this.logEntries;
    }

    public void setLogEntries(List<DomainObjectLogEntry> logEntries) {
        this.logEntries = logEntries;
    }

    public final String getValue() {
        return this.value;
    }

    public final void setValue(String value) {
        this.value = value;
    }

    public void addEntry(DomainObjectLogEntry logEntry) {
        if (this.logEntries == null) {
            this.logEntries = new ArrayList<DomainObjectLogEntry>();
        }
        this.logEntries.add(logEntry);
    }

    public void removeEntry(DomainObjectLogEntry logEntry) {
        if (this.logEntries == null) {
            return;
        }
        this.logEntries.remove(logEntry);
    }
}

