/*
 * Decompiled with CFR 0.152.
 */
package com.linkare.commons.jpa.logging;

import com.linkare.commons.jpa.DefaultDomainObject;
import com.linkare.commons.jpa.logging.DomainObjectLog;
import com.linkare.commons.jpa.logging.DomainObjectLogEntry;
import com.linkare.commons.jpa.utils.EntityManagerLocator;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Table;

@Entity
@Table(name="logged_domain_object")
public class LoggedDomainObject
extends DefaultDomainObject {
    private static final long serialVersionUID = 1L;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="loggedDomainObject")
    private DomainObjectLog log;

    public DomainObjectLog getLog() {
        return this.log;
    }

    public void setLog(DomainObjectLog log) {
        this.log = log;
    }

    private void addLog() {
        EntityManager em = EntityManagerLocator.getCurrentEntityManager();
        DomainObjectLog newLog = this.getLog();
        if (newLog == null) {
            newLog = new DomainObjectLog(this);
        }
        newLog.addEntry(new DomainObjectLogEntry(newLog, this));
        em.persist((Object)newLog);
    }

    @Override
    @PrePersist
    public void prePersist() {
        super.prePersist();
        this.addLog();
    }

    @Override
    @PreUpdate
    public void preUpdate() {
        super.preUpdate();
        this.addLog();
    }

    @Override
    @PreRemove
    public void preRemove() {
        super.preRemove();
        this.addLog();
    }
}

