/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.core;

import com.lordofthejars.nosqlunit.core.DatabaseOperation;
import com.lordofthejars.nosqlunit.core.LoadStrategyOperation;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanInsertLoadStrategyOperation
implements LoadStrategyOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanInsertLoadStrategyOperation.class);
    private DatabaseOperation databaseOperation;

    public CleanInsertLoadStrategyOperation(DatabaseOperation databaseOperation) {
        this.databaseOperation = databaseOperation;
    }

    @Override
    public void executeScripts(InputStream[] contentDataset) {
        LOGGER.debug("Calling Clean and Insert Load Strategy.");
        this.executeClean();
        if (contentDataset.length > 0) {
            this.executeInsert(contentDataset);
        }
    }

    private void executeInsert(InputStream[] contentDataset) {
        InputStream[] inputStreamArray = contentDataset;
        int n = contentDataset.length;
        int n2 = 0;
        while (n2 < n) {
            InputStream dataScript = inputStreamArray[n2];
            this.databaseOperation.insert(dataScript);
            ++n2;
        }
    }

    private void executeClean() {
        this.databaseOperation.deleteAll();
    }
}

