/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.core;

import java.util.HashMap;
import java.util.Map;

public final class ConnectionManagement {
    private static ConnectionManagement connectionManagement;
    private Map<Connection, Integer> currentConnections = new HashMap<Connection, Integer>();

    private ConnectionManagement() {
    }

    public static synchronized ConnectionManagement getInstance() {
        if (connectionManagement == null) {
            connectionManagement = new ConnectionManagement();
        }
        return connectionManagement;
    }

    public void addConnection(String host, int port) {
        Connection connection = new Connection(host, port);
        if (this.isConnectionRegistered(connection)) {
            int previousNumberOfConnections = this.currentConnections.remove(connection);
            this.currentConnections.put(connection, previousNumberOfConnections + 1);
        } else {
            this.currentConnections.put(new Connection(host, port), 1);
        }
    }

    public int removeConnection(String host, int port) {
        Connection connection = new Connection(host, port);
        if (this.isConnectionRegistered(connection)) {
            int previousNumberOfConnections = this.currentConnections.remove(connection);
            int numberCurrentConnections = previousNumberOfConnections - 1;
            if (numberCurrentConnections > 0) {
                this.currentConnections.put(connection, numberCurrentConnections);
            }
            return numberCurrentConnections;
        }
        return 0;
    }

    public boolean isConnectionRegistered(String host, int port) {
        return this.isConnectionRegistered(new Connection(host, port));
    }

    private boolean isConnectionRegistered(Connection connection) {
        return this.currentConnections.containsKey(connection);
    }

    private final class Connection {
        private final String host;
        private final int port;

        public Connection(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Connection other = (Connection)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            return this.port == other.port;
        }

        private ConnectionManagement getOuterType() {
            return ConnectionManagement.this;
        }
    }
}

