/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.core;

import com.lordofthejars.nosqlunit.core.IOUtils;
import com.lordofthejars.nosqlunit.util.DefaultClasspathLocationBuilder;
import java.lang.annotation.Annotation;
import org.junit.runners.model.FrameworkMethod;

public class DefaultDataSetLocationResolver {
    private Class<?> resourceBase;

    public DefaultDataSetLocationResolver(Class<?> resourceBase) {
        this.resourceBase = resourceBase;
    }

    public Class<?> getResourceBase() {
        return this.resourceBase;
    }

    public String resolveDefaultDataSetLocation(Annotation annotation, FrameworkMethod method, String suffix) {
        String defaultClassAnnotatedClasspath = DefaultClasspathLocationBuilder.defaultClassAnnotatedClasspathLocation(method);
        if (this.isMethodAnnotated(method, annotation)) {
            String defaultMethodAnnotatedClasspathFile = DefaultClasspathLocationBuilder.defaultMethodAnnotatedClasspathLocation(method, defaultClassAnnotatedClasspath, suffix);
            if (IOUtils.isFileAvailableOnClasspath(this.resourceBase, defaultMethodAnnotatedClasspathFile)) {
                return defaultMethodAnnotatedClasspathFile;
            }
            String defaultClassAnnotatedClasspathFile = String.valueOf(defaultClassAnnotatedClasspath) + suffix;
            if (IOUtils.isFileAvailableOnClasspath(this.resourceBase, defaultClassAnnotatedClasspathFile)) {
                return defaultClassAnnotatedClasspathFile;
            }
        } else {
            String defaultClassAnnotatedClasspathFile = String.valueOf(defaultClassAnnotatedClasspath) + suffix;
            if (IOUtils.isFileAvailableOnClasspath(this.resourceBase, defaultClassAnnotatedClasspathFile)) {
                return defaultClassAnnotatedClasspathFile;
            }
        }
        return null;
    }

    private boolean isMethodAnnotated(FrameworkMethod method, Annotation annotation) {
        return method.getAnnotation(annotation.annotationType()) != null;
    }
}

