/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.core;

import com.lordofthejars.nosqlunit.annotation.ByContainer;
import com.lordofthejars.nosqlunit.annotation.ConnectionManager;
import com.lordofthejars.nosqlunit.core.FieldSetter;
import com.lordofthejars.nosqlunit.core.IOUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;

public class InjectAnnotationProcessor {
    private String identifier;

    public InjectAnnotationProcessor(String identifier) {
        this.identifier = identifier;
    }

    void processInjectAnnotation(Class<?> clazz, Object testInstance, Object injectionObject) {
        if (this.isTargetSet(testInstance)) {
            HashSet<Field> fields = new HashSet<Field>();
            fields.addAll(IOUtils.getFieldsWithAnnotation(clazz, Inject.class));
            fields.addAll(IOUtils.getFieldsWithAnnotation(clazz, ConnectionManager.class));
            fields.addAll(IOUtils.getFieldsWithAnnotation(clazz, ByContainer.class));
            for (Field field : fields) {
                Named namedAnnotation;
                Inject injectAnnotation = field.getAnnotation(Inject.class);
                ConnectionManager connectionManagerAnnotation = field.getAnnotation(ConnectionManager.class);
                ByContainer byContainerAnnotation = field.getAnnotation(ByContainer.class);
                if (!this.isInjectedAndNotExternallyManaged((Annotation)injectAnnotation, byContainerAnnotation, connectionManagerAnnotation) || !this.isNamedAnnotationNotPresent((Annotation)(namedAnnotation = field.getAnnotation(Named.class))) && !this.isIdentifierValueInNamedAnnotation((Annotation)namedAnnotation) || !field.getType().isInstance(injectionObject)) continue;
                new FieldSetter(testInstance, field).set(injectionObject);
            }
        }
    }

    private boolean isInjectedAndNotExternallyManaged(Annotation injectAnnotation, Annotation byContainerAnnotation, Annotation connectionManagerAnnotation) {
        return injectAnnotation != null && byContainerAnnotation == null || connectionManagerAnnotation != null;
    }

    private boolean isIdentifierValueInNamedAnnotation(Annotation namedAnnotation) {
        String namedValue = ((Named)namedAnnotation).value();
        return "".equals(namedValue) || namedValue.equals(this.identifier);
    }

    private boolean isNamedAnnotationNotPresent(Annotation namedAnnotation) {
        return namedAnnotation == null;
    }

    private boolean isTargetSet(Object testInstance) {
        return testInstance != null;
    }
}

