/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.joor.Reflect;

public class KeyValueObjectMapper {
    private static final String NO_IMPLEMENTATION_PROVIDED = "";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public Map<Object, Object> readValues(InputStream dataStream) {
        HashMap<Object, Object> objects = new HashMap<Object, Object>();
        try {
            Iterator<JsonNode> elements = this.dataElements(dataStream);
            objects.putAll(this.readElements(elements));
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException(e);
        }
        catch (JsonMappingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Implementation class is not found in classpath", e);
        }
        return objects;
    }

    private Map<Object, Object> readElements(Iterator<JsonNode> elements) throws IOException, JsonParseException, JsonMappingException, ClassNotFoundException {
        HashMap<Object, Object> objects = new HashMap<Object, Object>();
        while (elements.hasNext()) {
            JsonNode element = elements.next();
            Object keyValue = this.keyValue(element);
            Object readValue = this.readValue(element);
            objects.put(keyValue, readValue);
        }
        return objects;
    }

    private Object readValue(JsonNode element) throws IOException, JsonParseException, JsonMappingException, ClassNotFoundException {
        JsonNode value = this.valueNode(element);
        String implementationValue = this.implementationClass(element);
        Object readObject = this.readElement(value, implementationValue);
        return readObject;
    }

    private Object readElement(JsonNode value, String implementationValue) throws IOException, JsonParseException, JsonMappingException, ClassNotFoundException {
        Object readObject = null;
        readObject = value.isArray() ? this.readArray(value, implementationValue) : this.readObject(value, implementationValue);
        return readObject;
    }

    private Object readObject(JsonNode value, String implementationValue) throws IOException, JsonParseException, JsonMappingException, ClassNotFoundException {
        Object readObject = value.isObject() ? this.unmarshallObject(value, implementationValue) : this.simpleValue(value);
        return readObject;
    }

    private Object unmarshallObject(JsonNode value, String implementationValue) throws IOException, JsonParseException, JsonMappingException, ClassNotFoundException {
        if (NO_IMPLEMENTATION_PROVIDED.equals(implementationValue)) {
            throw new IllegalArgumentException("No implementation class has been provided.");
        }
        return OBJECT_MAPPER.readValue(value, Class.forName(implementationValue));
    }

    private Object readArray(JsonNode value, String implementationValue) throws IOException, JsonParseException, JsonMappingException, ClassNotFoundException {
        Iterator elements = value.getElements();
        Collection<Object> objects = this.collection(implementationValue);
        while (elements.hasNext()) {
            JsonNode newElement = (JsonNode)elements.next();
            objects.add(this.readValue(newElement));
        }
        Collection<Object> readObject = objects;
        return readObject;
    }

    private String implementationKeyClass(JsonNode element) {
        String implementationValue = NO_IMPLEMENTATION_PROVIDED;
        if (element.has("implementationKey")) {
            implementationValue = element.path("implementationKey").getTextValue();
        }
        return implementationValue.trim();
    }

    private String implementationClass(JsonNode element) {
        String implementationValue = NO_IMPLEMENTATION_PROVIDED;
        if (element.has("implementation")) {
            implementationValue = element.path("implementation").getTextValue();
        }
        return implementationValue.trim();
    }

    private JsonNode valueNode(JsonNode element) {
        if (element.has("value")) {
            return element.path("value");
        }
        throw new IllegalArgumentException("Given dataset does not contain value token.");
    }

    private Collection<Object> collection(String implementation) {
        if (implementation.equals(NO_IMPLEMENTATION_PROVIDED)) {
            return new ArrayList<Object>();
        }
        return (Collection)Reflect.on((String)implementation).create().get();
    }

    private Object simpleValue(JsonNode simpleValue) {
        if (simpleValue.isNumber()) {
            switch (simpleValue.getNumberType()) {
                case BIG_DECIMAL: {
                    return simpleValue.getDecimalValue();
                }
                case BIG_INTEGER: {
                    return simpleValue.getBigIntegerValue();
                }
                case DOUBLE: {
                    return simpleValue.getDoubleValue();
                }
                case FLOAT: {
                    return simpleValue.getDoubleValue();
                }
                case INT: {
                    return simpleValue.getIntValue();
                }
                case LONG: {
                    return simpleValue.getLongValue();
                }
            }
            return simpleValue.getTextValue();
        }
        return simpleValue.getTextValue();
    }

    private Object keyValue(JsonNode element) throws JsonParseException, JsonMappingException, IOException, ClassNotFoundException {
        if (!element.has("key")) {
            throw new IllegalArgumentException("Given dataset does not contain key token.");
        }
        String implementationKey = this.implementationKeyClass(element);
        Object keyValue = this.readElement(element.path("key"), implementationKey);
        return keyValue;
    }

    private Iterator<JsonNode> dataElements(InputStream dataStream) throws IOException, JsonParseException, JsonMappingException {
        JsonNode rootNode = (JsonNode)OBJECT_MAPPER.readValue(dataStream, JsonNode.class);
        JsonNode dataNode = rootNode.path("data");
        Iterator elements = dataNode.getElements();
        return elements;
    }
}

