/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.mongodb.shard;

import ch.lambdaj.Lambda;
import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.mongodb.ManagedMongoDbLifecycleManager;
import com.lordofthejars.nosqlunit.mongodb.replicaset.ReplicaSetManagedMongoDb;
import com.lordofthejars.nosqlunit.mongodb.shard.ManagedMongosLifecycleManager;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class ShardedGroup {
    private List<ManagedMongoDbLifecycleManager> shards = new ArrayList<ManagedMongoDbLifecycleManager>();
    private List<ManagedMongoDbLifecycleManager> configs = new ArrayList<ManagedMongoDbLifecycleManager>();
    private List<ManagedMongosLifecycleManager> mongos = new ArrayList<ManagedMongosLifecycleManager>();
    private List<ReplicaSetManagedMongoDb> replicaSets = new ArrayList<ReplicaSetManagedMongoDb>();
    private String username;
    private String password;

    public void addShard(ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager) {
        this.shards.add(managedMongoDbLifecycleManager);
    }

    public void addConfig(ManagedMongoDbLifecycleManager managedMongoDbLifecycleManager) {
        this.configs.add(managedMongoDbLifecycleManager);
    }

    public void addMongos(ManagedMongosLifecycleManager managedMongosLifecycleManager) {
        this.mongos.add(managedMongosLifecycleManager);
    }

    public void addReplicaSet(ReplicaSetManagedMongoDb replicaSetManagedMongoDb) {
        this.replicaSets.add(replicaSetManagedMongoDb);
    }

    public ManagedMongosLifecycleManager getFirstMongosServer() {
        if (this.mongos.size() > 0) {
            return this.mongos.get(0);
        }
        throw new IllegalArgumentException("At least one Mongos server is required for sharding");
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAuthenticationSet() {
        return this.username != null && this.password != null;
    }

    public AbstractLifecycleManager getStoppingServer(int port) {
        return this.getServerByPortAndState(port, true);
    }

    public AbstractLifecycleManager getStartingServer(int port) {
        return this.getServerByPortAndState(port, false);
    }

    public boolean isOnlyShards() {
        return this.getShards().size() > 0 && this.getReplicaSets().size() == 0;
    }

    public boolean isOnlyReplicaSetShards() {
        return this.getShards().size() == 0 && this.getReplicaSets().size() > 0;
    }

    public boolean isShardsAndReplicSetShardsMixed() {
        return this.getShards().size() != 0 && this.getReplicaSets().size() != 0;
    }

    private AbstractLifecycleManager getServerByPortAndState(int port, boolean state) {
        AbstractLifecycleManager abstractLifecycleManager = (AbstractLifecycleManager)Lambda.selectFirst(this.shards, (Matcher)Lambda.having((Object)((ManagedMongoDbLifecycleManager)((Object)Lambda.on(ManagedMongoDbLifecycleManager.class))).getPort(), (Matcher)CoreMatchers.is((Object)port)).and((Matcher)Lambda.having((Object)((ManagedMongoDbLifecycleManager)((Object)Lambda.on(ManagedMongoDbLifecycleManager.class))).isReady(), (Matcher)CoreMatchers.is((Object)state))));
        if (abstractLifecycleManager == null && (abstractLifecycleManager = (AbstractLifecycleManager)Lambda.selectFirst(this.configs, (Matcher)Lambda.having((Object)((ManagedMongoDbLifecycleManager)((Object)Lambda.on(ManagedMongoDbLifecycleManager.class))).getPort(), (Matcher)CoreMatchers.is((Object)port)).and((Matcher)Lambda.having((Object)((ManagedMongoDbLifecycleManager)((Object)Lambda.on(ManagedMongoDbLifecycleManager.class))).isReady(), (Matcher)CoreMatchers.is((Object)state))))) == null && (abstractLifecycleManager = (AbstractLifecycleManager)Lambda.selectFirst(this.mongos, (Matcher)Lambda.having((Object)((ManagedMongoDbLifecycleManager)((Object)Lambda.on(ManagedMongoDbLifecycleManager.class))).getPort(), (Matcher)CoreMatchers.is((Object)port)).and((Matcher)Lambda.having((Object)((ManagedMongoDbLifecycleManager)((Object)Lambda.on(ManagedMongoDbLifecycleManager.class))).isReady(), (Matcher)CoreMatchers.is((Object)state))))) == null) {
            for (ReplicaSetManagedMongoDb replicaSetManagedMongoDb : this.replicaSets) {
                ManagedMongoDbLifecycleManager serverByPortAndState = replicaSetManagedMongoDb.getServerByPortAndState(port, state);
                if (serverByPortAndState == null) continue;
                abstractLifecycleManager = serverByPortAndState;
                break;
            }
        }
        return abstractLifecycleManager;
    }

    public List<ManagedMongoDbLifecycleManager> getShards() {
        return this.shards;
    }

    public List<ManagedMongoDbLifecycleManager> getConfigs() {
        return this.configs;
    }

    public List<ManagedMongosLifecycleManager> getMongos() {
        return this.mongos;
    }

    public List<ReplicaSetManagedMongoDb> getReplicaSets() {
        return this.replicaSets;
    }
}

