/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import com.lordofthejars.nosqlunit.core.FailureHandler;
import com.lordofthejars.nosqlunit.redis.EmbeddedRedisInstances;
import com.lordofthejars.nosqlunit.redis.RedisConfiguration;
import com.lordofthejars.nosqlunit.redis.RedisOperation;
import redis.clients.jedis.Jedis;

public class EmbeddedRedisConfigurationBuilder {
    private RedisConfiguration redisConfiguration = new RedisConfiguration();

    private EmbeddedRedisConfigurationBuilder() {
    }

    public static EmbeddedRedisConfigurationBuilder newEmbeddedRedisConfiguration() {
        return new EmbeddedRedisConfigurationBuilder();
    }

    public EmbeddedRedisConfigurationBuilder connectionIdentifier(String connectionIdentifier) {
        this.redisConfiguration.setConnectionIdentifier(connectionIdentifier);
        return this;
    }

    public RedisConfiguration build() {
        Jedis jedis = EmbeddedRedisInstances.getInstance().getDefaultJedis();
        if (jedis == null) {
            throw FailureHandler.createIllegalStateFailure((String)"There is no EmbeddedRedis rule during test execution. Please create one using @Rule or @ClassRule before executing these tests.", (Object[])new Object[0]);
        }
        this.redisConfiguration.setDatabaseOperation(new RedisOperation(jedis));
        return this.redisConfiguration;
    }

    public RedisConfiguration buildFromTargetPath(String targetPath) {
        Jedis jedis = EmbeddedRedisInstances.getInstance().getJedisByTargetPath(targetPath);
        if (jedis == null) {
            throw FailureHandler.createIllegalStateFailure((String)"There is no EmbeddedRedis rule with %s target defined during test execution. Please create one using @Rule or @ClassRule before executing these tests.", (Object[])new Object[]{targetPath});
        }
        this.redisConfiguration.setDatabaseOperation(new RedisOperation(jedis));
        return this.redisConfiguration;
    }
}

