/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import com.lordofthejars.nosqlunit.core.AbstractLifecycleManager;
import com.lordofthejars.nosqlunit.redis.EmbeddedRedis;
import com.lordofthejars.nosqlunit.redis.EmbeddedRedisInstances;
import com.lordofthejars.nosqlunit.redis.embedded.EmbeddedRedisBuilder;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class EmbeddedRedisLifecycleManager
extends AbstractLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedRedis.class);
    protected static final String LOCALHOST = "127.0.0.1";
    protected static final int PORT = 6379;
    public static final String INMEMORY_REDIS_TARGET_PATH = "target" + File.separatorChar + "redis-test-data" + File.separatorChar + "impermanent-db";
    private String targetPath = INMEMORY_REDIS_TARGET_PATH;
    private Jedis jedis;

    protected String getHost() {
        return LOCALHOST + this.targetPath;
    }

    protected int getPort() {
        return 6379;
    }

    protected void doStart() throws Throwable {
        LOGGER.info("Starting Embedded InMemory Redis instance.");
        this.jedis = this.createEmbeddedRedis();
        EmbeddedRedisInstances.getInstance().addJedis(this.jedis, this.targetPath);
        LOGGER.info("Started Embedded InMemory Redis instance.");
    }

    protected void doStop() {
        LOGGER.info("Stopping Embedded InMemory Redis instance.");
        EmbeddedRedisInstances.getInstance().removeJedis(this.targetPath);
        LOGGER.info("Stopped Embedded InMemory Redis instance.");
    }

    private Jedis createEmbeddedRedis() {
        EmbeddedRedisBuilder embeddedRedisBuilder = new EmbeddedRedisBuilder();
        return embeddedRedisBuilder.createEmbeddedJedis();
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }
}

