/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import com.lordofthejars.nosqlunit.redis.ManagedRedisLifecycleManager;
import org.junit.rules.ExternalResource;

public class ManagedRedis
extends ExternalResource {
    protected ManagedRedisLifecycleManager managedRedisLifecycleManager;

    private ManagedRedis() {
    }

    protected void before() throws Throwable {
        this.managedRedisLifecycleManager.startEngine();
    }

    protected void after() {
        this.managedRedisLifecycleManager.stopEngine();
    }

    public static class ManagedRedisRuleBuilder {
        private ManagedRedisLifecycleManager managedRedisLifecycleManager = new ManagedRedisLifecycleManager();

        private ManagedRedisRuleBuilder() {
        }

        public static ManagedRedisRuleBuilder newManagedRedisRule() {
            return new ManagedRedisRuleBuilder();
        }

        public ManagedRedisRuleBuilder port(int port) {
            this.managedRedisLifecycleManager.setPort(port);
            return this;
        }

        public ManagedRedisRuleBuilder targetPath(String targetPath) {
            this.managedRedisLifecycleManager.setTargetPath(targetPath);
            return this;
        }

        public ManagedRedisRuleBuilder redisPath(String redisPath) {
            this.managedRedisLifecycleManager.setRedisPath(redisPath);
            return this;
        }

        public ManagedRedisRuleBuilder configurationPath(String configurationPath) {
            this.managedRedisLifecycleManager.setConfigurationFilepath(configurationPath);
            return this;
        }

        public ManagedRedisRuleBuilder appendCommandLineArguments(String argumentName, String argumentValue) {
            this.managedRedisLifecycleManager.addExtraCommandLineArgument(argumentName, argumentValue);
            return this;
        }

        public ManagedRedisRuleBuilder appendSingleCommandLineArguments(String argument) {
            this.managedRedisLifecycleManager.addSingleCommandLineArgument(argument);
            return this;
        }

        public ManagedRedis build() {
            if (this.managedRedisLifecycleManager.getRedisPath() == null) {
                throw new IllegalArgumentException("Redis Path cannot be null.");
            }
            ManagedRedis managedRedis = new ManagedRedis();
            managedRedis.managedRedisLifecycleManager = this.managedRedisLifecycleManager;
            return managedRedis;
        }
    }
}

