/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import com.lordofthejars.nosqlunit.core.DatabaseOperation;
import com.lordofthejars.nosqlunit.redis.RedisAssertion;
import com.lordofthejars.nosqlunit.redis.RedisConnectionCallback;
import com.lordofthejars.nosqlunit.redis.parser.DataReader;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.Jedis;

public class RedisOperation
implements DatabaseOperation<Jedis> {
    private Jedis jedis;
    private DataReader dataReader;

    public RedisOperation(Jedis jedis) {
        this.jedis = jedis;
        this.dataReader = new DataReader((BinaryJedisCommands)jedis);
    }

    public void insert(InputStream dataScript) {
        this.dataReader.read(dataScript);
    }

    public void deleteAll() {
        this.jedis.flushAll();
    }

    public boolean databaseIs(InputStream expectedData) {
        RedisAssertion.strictAssertEquals(new RedisConnectionCallback(){

            public List<Jedis> getAllJedis() {
                return Arrays.asList(RedisOperation.this.jedis);
            }

            @Override
            public Jedis getActiveJedis(byte[] key) {
                return RedisOperation.this.jedis;
            }
        }, expectedData);
        return true;
    }

    public Jedis connectionManager() {
        return this.jedis;
    }
}

