/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import com.lordofthejars.nosqlunit.redis.RedisConfiguration;
import com.lordofthejars.nosqlunit.redis.RedisOperation;
import redis.clients.jedis.Jedis;

public class RemoteRedisConfigurationBuilder {
    private static final int DEFAULT_PORT = 6379;
    private RedisConfiguration redisConfiguration = new RedisConfiguration();

    private RemoteRedisConfigurationBuilder() {
        this.redisConfiguration.setPort(6379);
    }

    public static RemoteRedisConfigurationBuilder newRemoteRedisConfiguration() {
        return new RemoteRedisConfigurationBuilder();
    }

    public RemoteRedisConfigurationBuilder host(String host) {
        this.redisConfiguration.setHost(host);
        return this;
    }

    public RemoteRedisConfigurationBuilder port(int port) {
        this.redisConfiguration.setPort(port);
        return this;
    }

    public RemoteRedisConfigurationBuilder connectionIdentifier(String connectionIdentifier) {
        this.redisConfiguration.setConnectionIdentifier(connectionIdentifier);
        return this;
    }

    public RemoteRedisConfigurationBuilder password(String password) {
        this.redisConfiguration.setPassword(password);
        return this;
    }

    public RemoteRedisConfigurationBuilder slaveOf(String masterHost, int masterPort) {
        this.redisConfiguration.salveOf(masterHost, masterPort);
        return this;
    }

    public RedisConfiguration build() {
        String status;
        if (this.redisConfiguration.getHost() == null) {
            throw new IllegalArgumentException("Host parameter should be provided.");
        }
        Jedis jedis = new Jedis(this.redisConfiguration.getHost(), this.redisConfiguration.getPort());
        if (this.redisConfiguration.getPassword() != null && !"OK".equalsIgnoreCase(status = jedis.auth(this.redisConfiguration.getPassword()))) {
            throw new IllegalStateException("Password is not valid and Redis access cannot be accept commands.");
        }
        if (this.redisConfiguration.isSlave()) {
            jedis.slaveof(this.redisConfiguration.getMasterHost(), this.redisConfiguration.getMasterPort());
        }
        this.redisConfiguration.setDatabaseOperation(new RedisOperation(jedis));
        return this.redisConfiguration;
    }
}

