/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import com.lordofthejars.nosqlunit.redis.ShardedRedisConfiguration;
import com.lordofthejars.nosqlunit.redis.ShardedRedisOperation;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;

public class ShardedRedisConfigurationBuilder {
    private List<ShardInfoBuilder> shardInfoBuilders = new ArrayList<ShardInfoBuilder>();
    private ShardedRedisConfiguration redisConfiguration = new ShardedRedisConfiguration();

    private ShardedRedisConfigurationBuilder() {
    }

    public static ShardedRedisConfigurationBuilder newShardedRedisConfiguration() {
        return new ShardedRedisConfigurationBuilder();
    }

    public static String host(String host) {
        return host;
    }

    public static int port(int port) {
        return port;
    }

    public ShardInfoBuilder shard(String host, int port) {
        ShardInfoBuilder child = new ShardInfoBuilder(this);
        this.shardInfoBuilders.add(child);
        child.host = host;
        child.port = port;
        return child;
    }

    public ShardedRedisConfiguration build() {
        ArrayList<JedisShardInfo> jedisShardInfos = new ArrayList<JedisShardInfo>();
        for (ShardInfoBuilder shardInfoBuilder : this.shardInfoBuilders) {
            jedisShardInfos.add(shardInfoBuilder.getContent());
        }
        ShardedRedisOperation shardedRedisOperation = new ShardedRedisOperation(new ShardedJedis(jedisShardInfos));
        this.redisConfiguration.setDatabaseOperation(shardedRedisOperation);
        return this.redisConfiguration;
    }

    public ShardedRedisConfigurationBuilder connectionIdentifier(String connectionIdentifier) {
        this.redisConfiguration.setConnectionIdentifier(connectionIdentifier);
        return this;
    }

    public class ShardInfoBuilder {
        private ShardedRedisConfigurationBuilder parent;
        private static final int DEFAULT_TIMEOUT_IN_MILLIS = 2000;
        private String host;
        private int port;
        private String password;
        private int timeout = 2000;
        private int weight = 1;

        private ShardInfoBuilder(ShardedRedisConfigurationBuilder parent) {
            this.parent = parent;
        }

        public ShardInfoBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ShardInfoBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public ShardInfoBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public ShardInfoBuilder shard(String host, int port) {
            return this.parent.shard(host, port);
        }

        public ShardedRedisConfiguration build() {
            return this.parent.build();
        }

        private JedisShardInfo getContent() {
            JedisShardInfo jedisShardInfo = new JedisShardInfo(this.host, this.port, this.timeout, this.weight);
            jedisShardInfo.setPassword(this.password);
            return jedisShardInfo;
        }
    }
}

