/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis;

import ch.lambdaj.Lambda;
import com.lordofthejars.nosqlunit.core.DatabaseOperation;
import com.lordofthejars.nosqlunit.redis.RedisAssertion;
import com.lordofthejars.nosqlunit.redis.RedisConnectionCallback;
import com.lordofthejars.nosqlunit.redis.parser.DataReader;
import java.io.InputStream;
import java.util.Collection;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ShardedJedis;

public class ShardedRedisOperation
implements DatabaseOperation<ShardedJedis> {
    private ShardedJedis shardedJedis;
    private DataReader dataReader;

    public ShardedRedisOperation(ShardedJedis shardedJedis) {
        this.shardedJedis = shardedJedis;
        this.dataReader = new DataReader((BinaryJedisCommands)shardedJedis);
    }

    public void insert(InputStream dataScript) {
        this.dataReader.read(dataScript);
    }

    public void deleteAll() {
        ((Jedis)Lambda.forEach((Iterable)this.shardedJedis.getAllShards())).flushAll();
    }

    public boolean databaseIs(InputStream expectedData) {
        RedisAssertion.strictAssertEquals(new RedisConnectionCallback(){

            @Override
            public Collection<Jedis> getAllJedis() {
                return ShardedRedisOperation.this.shardedJedis.getAllShards();
            }

            @Override
            public Jedis getActiveJedis(byte[] key) {
                return (Jedis)ShardedRedisOperation.this.shardedJedis.getShard(key);
            }
        }, expectedData);
        return true;
    }

    public ShardedJedis connectionManager() {
        return this.shardedJedis;
    }
}

