/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.embedded;

import ch.lambdaj.collection.LambdaCollections;
import ch.lambdaj.function.convert.Converter;
import com.lordofthejars.nosqlunit.redis.embedded.ByteArrayToStringConverter;
import com.lordofthejars.nosqlunit.redis.embedded.ConnectionServerOperations;
import com.lordofthejars.nosqlunit.redis.embedded.HashDatatypeOperations;
import com.lordofthejars.nosqlunit.redis.embedded.KeysServerOperations;
import com.lordofthejars.nosqlunit.redis.embedded.ListDatatypeOperations;
import com.lordofthejars.nosqlunit.redis.embedded.PubSubServerOperations;
import com.lordofthejars.nosqlunit.redis.embedded.ScriptingServerOperations;
import com.lordofthejars.nosqlunit.redis.embedded.SetDatatypeOperations;
import com.lordofthejars.nosqlunit.redis.embedded.SortsetDatatypeOperations;
import com.lordofthejars.nosqlunit.redis.embedded.StringDatatypeOperations;
import com.lordofthejars.nosqlunit.redis.embedded.StringToByteArrayConverter;
import com.lordofthejars.nosqlunit.redis.embedded.TransactionServerOperations;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisMonitor;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.PipelineBlock;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.TransactionBlock;
import redis.clients.jedis.Tuple;
import redis.clients.util.Slowlog;

public class EmbeddedJedis
implements JedisCommands,
BinaryJedisCommands {
    private static final ByteArrayToStringConverter BYTE_ARRAY_TO_STRING_CONVERTER = ByteArrayToStringConverter.createByteArrayToStringConverter();
    private static final StringToByteArrayConverter STRING_TO_BYTE_ARRAY_CONVERTER = StringToByteArrayConverter.createStringToByteArrayConverter();
    protected HashDatatypeOperations hashDatatypeOperations = new HashDatatypeOperations();
    protected ListDatatypeOperations listDatatypeOperations = new ListDatatypeOperations();
    protected SetDatatypeOperations setDatatypeOperations = new SetDatatypeOperations();
    protected SortsetDatatypeOperations sortsetDatatypeOperations = new SortsetDatatypeOperations();
    protected StringDatatypeOperations stringDatatypeOperations = new StringDatatypeOperations();
    protected KeysServerOperations keysServerOperations;
    protected PubSubServerOperations pubSubServerOperations = new PubSubServerOperations();
    protected ConnectionServerOperations connectionServerOperations = new ConnectionServerOperations();
    protected ScriptingServerOperations scriptingServerOperations = new ScriptingServerOperations();
    protected TransactionServerOperations transactionServerOperations = new TransactionServerOperations();

    public EmbeddedJedis() {
        this.keysServerOperations = KeysServerOperations.createKeysServerOperations(this.hashDatatypeOperations, this.listDatatypeOperations, this.setDatatypeOperations, this.sortsetDatatypeOperations, this.stringDatatypeOperations);
    }

    public String set(byte[] key, byte[] value) {
        this.keysServerOperations.del(new byte[][]{key});
        this.stringDatatypeOperations.removeExpiration(key);
        return this.stringDatatypeOperations.set(key, value);
    }

    public byte[] get(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        return this.stringDatatypeOperations.get(key);
    }

    public Boolean exists(byte[] key) {
        this.updateTtl(key);
        return this.stringDatatypeOperations.exists(key);
    }

    public String type(byte[] key) {
        this.updateTtl(key);
        return this.keysServerOperations.type(key);
    }

    public Long expire(byte[] key, int seconds) {
        return this.keysServerOperations.expire(key, seconds);
    }

    public Long expireAt(byte[] key, long unixTime) {
        return this.keysServerOperations.expireAt(key, unixTime);
    }

    public Long ttl(byte[] key) {
        return this.keysServerOperations.ttl(key);
    }

    public byte[] getSet(byte[] key, byte[] value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        this.stringDatatypeOperations.removeExpiration(key);
        return this.stringDatatypeOperations.getSet(key, value);
    }

    public Long setnx(byte[] key, byte[] value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        return this.stringDatatypeOperations.setnx(key, value);
    }

    public String setex(byte[] key, int seconds, byte[] value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        return this.stringDatatypeOperations.setex(key, seconds, value);
    }

    public Long decrBy(byte[] key, long integer) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        return this.stringDatatypeOperations.decrBy(key, integer);
    }

    public Long decr(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        return this.stringDatatypeOperations.decr(key);
    }

    public Long incrBy(byte[] key, long integer) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        return this.stringDatatypeOperations.incrBy(key, integer);
    }

    public Long incr(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        return this.stringDatatypeOperations.incr(key);
    }

    public Long append(byte[] key, byte[] value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        return this.stringDatatypeOperations.append(key, value);
    }

    public byte[] substr(byte[] key, int start, int end) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        return this.stringDatatypeOperations.substr(key, start, end);
    }

    public Long hset(byte[] key, byte[] field, byte[] value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "hash");
        return this.hashDatatypeOperations.hset(key, field, value);
    }

    public byte[] hget(byte[] key, byte[] field) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "hash");
        return this.hashDatatypeOperations.hget(key, field);
    }

    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "hash");
        return this.hashDatatypeOperations.hsetnx(key, field, value);
    }

    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "hash");
        return this.hashDatatypeOperations.hmset(key, hash);
    }

    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "hash");
        return this.hashDatatypeOperations.hmget(key, fields);
    }

    public Long hincrBy(byte[] key, byte[] field, long value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "hash");
        return this.hashDatatypeOperations.hincrBy(key, field, value);
    }

    public Boolean hexists(byte[] key, byte[] field) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "hash");
        return this.hashDatatypeOperations.hexists(key, field);
    }

    public Long hdel(byte[] key, byte[] ... fields) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "hash");
        return this.hashDatatypeOperations.hdel(key, fields);
    }

    public Long hlen(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "hash");
        return this.hashDatatypeOperations.hlen(key);
    }

    public Set<byte[]> hkeys(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "hash");
        return this.hashDatatypeOperations.hkeys(key);
    }

    public Collection<byte[]> hvals(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "hash");
        return this.hashDatatypeOperations.hvals(key);
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "hash");
        return this.hashDatatypeOperations.hgetAll(key);
    }

    public Long rpush(byte[] key, byte[] ... values) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "list");
        return this.listDatatypeOperations.rpush(key, values);
    }

    public Long lpush(byte[] key, byte[] ... values) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "list");
        return this.listDatatypeOperations.lpush(key, values);
    }

    public Long llen(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "list");
        return this.listDatatypeOperations.llen(key);
    }

    public List<byte[]> lrange(byte[] key, int start, int end) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "list");
        return this.listDatatypeOperations.lrange(key, start, end);
    }

    public String ltrim(byte[] key, int start, int end) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "list");
        return this.listDatatypeOperations.ltrim(key, start, end);
    }

    public byte[] lindex(byte[] key, int index) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "list");
        return this.listDatatypeOperations.lindex(key, index);
    }

    public String lset(byte[] key, int index, byte[] value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "list");
        return this.listDatatypeOperations.lset(key, index, value);
    }

    public Long lrem(byte[] key, int count, byte[] value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "list");
        return this.listDatatypeOperations.lrem(key, count, value);
    }

    public byte[] lpop(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "list");
        return this.listDatatypeOperations.lpop(key);
    }

    public byte[] rpop(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "list");
        return this.listDatatypeOperations.rpop(key);
    }

    public Long sadd(byte[] key, byte[] ... member) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "set");
        return this.setDatatypeOperations.sadd(key, member);
    }

    public Set<byte[]> smembers(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "set");
        return this.setDatatypeOperations.smembers(key);
    }

    public Long srem(byte[] key, byte[] ... member) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "set");
        return this.setDatatypeOperations.srem(key, member);
    }

    public byte[] spop(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "set");
        return this.setDatatypeOperations.spop(key);
    }

    public Long scard(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "set");
        return this.setDatatypeOperations.scard(key);
    }

    public Boolean sismember(byte[] key, byte[] member) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "set");
        return this.setDatatypeOperations.sismember(key, member);
    }

    public byte[] srandmember(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "set");
        return this.setDatatypeOperations.srandmember(key);
    }

    public Long zadd(byte[] key, double score, byte[] member) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zadd(key, score, member);
    }

    public Long zadd(byte[] key, Map<Double, byte[]> scoreMembers) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zadd(key, scoreMembers);
    }

    public Set<byte[]> zrange(byte[] key, int start, int end) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zrange(key, start, end);
    }

    public Long zrem(byte[] key, byte[] ... members) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zrem(key, members);
    }

    public Double zincrby(byte[] key, double score, byte[] member) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zincrby(key, score, member);
    }

    public Long zrank(byte[] key, byte[] member) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zrank(key, member);
    }

    public Long zrevrank(byte[] key, byte[] member) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zrevrank(key, member);
    }

    public Set<byte[]> zrevrange(byte[] key, int start, int end) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zrevrange(key, start, end);
    }

    public Set<Tuple> zrangeWithScores(byte[] key, int start, int end) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        Set<SortsetDatatypeOperations.ScoredByteBuffer> rangeWithScore = this.sortsetDatatypeOperations.zrangeWithScores(key, start, end);
        return new LinkedHashSet<Tuple>((Collection<Tuple>)LambdaCollections.with(rangeWithScore).convert(this.toTuple()));
    }

    public Set<Tuple> zrevrangeWithScores(byte[] key, int start, int end) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        Set<SortsetDatatypeOperations.ScoredByteBuffer> rangeWithScore = this.sortsetDatatypeOperations.zrevrangeWithScores(key, start, end);
        return new LinkedHashSet<Tuple>((Collection<Tuple>)LambdaCollections.with(rangeWithScore).convert(this.toTuple()));
    }

    public Long zcard(byte[] key) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zcard(key);
    }

    public Double zscore(byte[] key, byte[] member) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zscore(key, member);
    }

    public List<byte[]> sort(byte[] key) {
        this.updateTtl(key);
        return this.keysServerOperations.sort(key);
    }

    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        throw new UnsupportedOperationException("Sort with parameters is not supported.");
    }

    public Long zcount(byte[] key, double min, double max) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zcount(key, min, max);
    }

    public Long zcount(byte[] key, byte[] min, byte[] max) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zcount(key, min, max);
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zrangeByScore(key, min, max);
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zrangeByScore(key, min, max, offset, count);
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        Set<SortsetDatatypeOperations.ScoredByteBuffer> zrangeByScoreWithScores = this.sortsetDatatypeOperations.zrangeByScoreWithScores(key, min, max);
        return new LinkedHashSet<Tuple>((Collection<Tuple>)LambdaCollections.with(zrangeByScoreWithScores).convert(this.toTuple()));
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        Set<SortsetDatatypeOperations.ScoredByteBuffer> zrangeByScoreWithScores = this.sortsetDatatypeOperations.zrangeByScoreWithScores(key, min, max, offset, count);
        return new LinkedHashSet<Tuple>((Collection<Tuple>)LambdaCollections.with(zrangeByScoreWithScores).convert(this.toTuple()));
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        Set<SortsetDatatypeOperations.ScoredByteBuffer> zrangeByScoreWithScores = this.sortsetDatatypeOperations.zrangeByScoreWithScores(key, min, max);
        return new LinkedHashSet<Tuple>((Collection<Tuple>)LambdaCollections.with(zrangeByScoreWithScores).convert(this.toTuple()));
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        Set<SortsetDatatypeOperations.ScoredByteBuffer> zrangeByScoreWithScores = this.sortsetDatatypeOperations.zrangeByScoreWithScores(key, min, max, offset, count);
        return new LinkedHashSet<Tuple>((Collection<Tuple>)LambdaCollections.with(zrangeByScoreWithScores).convert(this.toTuple()));
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zrevrangeByScore(key, max, min);
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zrevrangeByScore(key, max, min, offset, count);
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zrevrangeByScore(key, max, min);
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zrevrangeByScore(key, max, min);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        Set<SortsetDatatypeOperations.ScoredByteBuffer> zrangeByScoreWithScores = this.sortsetDatatypeOperations.zrevrangeByScoreWithScores(key, max, min);
        return new LinkedHashSet<Tuple>((Collection<Tuple>)LambdaCollections.with(zrangeByScoreWithScores).convert(this.toTuple()));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        Set<SortsetDatatypeOperations.ScoredByteBuffer> zrangeByScoreWithScores = this.sortsetDatatypeOperations.zrevrangeByScoreWithScores(key, max, min, offset, count);
        return new LinkedHashSet<Tuple>((Collection<Tuple>)LambdaCollections.with(zrangeByScoreWithScores).convert(this.toTuple()));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        Set<SortsetDatatypeOperations.ScoredByteBuffer> zrangeByScoreWithScores = this.sortsetDatatypeOperations.zrevrangeByScoreWithScores(key, max, min);
        return new LinkedHashSet<Tuple>((Collection<Tuple>)LambdaCollections.with(zrangeByScoreWithScores).convert(this.toTuple()));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        Set<SortsetDatatypeOperations.ScoredByteBuffer> zrangeByScoreWithScores = this.sortsetDatatypeOperations.zrevrangeByScoreWithScores(key, max, min, offset, count);
        return new LinkedHashSet<Tuple>((Collection<Tuple>)LambdaCollections.with(zrangeByScoreWithScores).convert(this.toTuple()));
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zrangeByScore(key, min, max);
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zrangeByScore(key, min, max, offset, count);
    }

    public Long zremrangeByRank(byte[] key, int start, int end) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zremrangeByRank(key, start, end);
    }

    public Long zremrangeByScore(byte[] key, double start, double end) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zremrangeByScore(key, start, end);
    }

    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "zset");
        return this.sortsetDatatypeOperations.zremrangeByScore(key, start, end);
    }

    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "list");
        return this.listDatatypeOperations.linsert(key, (ListDatatypeOperations.ListPositionEnum)((Object)this.toListPosition().convert((Object)where)), pivot, value);
    }

    public Long objectRefcount(byte[] key) {
        return this.keysServerOperations.objectRefcount(key);
    }

    public Long objectIdletime(byte[] key) {
        return this.keysServerOperations.objectIdletime(key);
    }

    public byte[] objectEncoding(byte[] key) {
        return this.keysServerOperations.objectEncoding(key);
    }

    public Long objectRefcount(String key) {
        return this.objectRefcount((byte[])this.toByteArray().convert((Object)key));
    }

    public Long objectIdletime(String key) {
        return this.objectIdletime((byte[])this.toByteArray().convert((Object)key));
    }

    public byte[] objectEncoding(String key) {
        return this.objectEncoding((byte[])this.toByteArray().convert((Object)key));
    }

    public void psubscribe(JedisPubSub jedisPubSub, byte[] ... patterns) {
        this.pubSubServerOperations.psubscribe(jedisPubSub, patterns);
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        byte[][] arrayOfPatterns = (byte[][])LambdaCollections.with((Object[])patterns).convert(this.toByteArray()).toArray((Object[])new byte[patterns.length][]);
        this.psubscribe(jedisPubSub, arrayOfPatterns);
    }

    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns) {
        this.pubSubServerOperations.psubscribe(jedisPubSub, patterns);
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        byte[][] arrayOfChanenls = (byte[][])LambdaCollections.with((Object[])channels).convert(this.toByteArray()).toArray((Object[])new byte[channels.length][]);
        this.subscribe(jedisPubSub, arrayOfChanenls);
    }

    public void subscribe(JedisPubSub jedisPubSub, byte[] ... channels) {
        this.pubSubServerOperations.subscribe(jedisPubSub, channels);
    }

    public void psubscribe(BinaryJedisPubSub jedisPubSub, String ... patterns) {
        byte[][] arrayOfPatterns = (byte[][])LambdaCollections.with((Object[])patterns).convert(this.toByteArray()).toArray((Object[])new byte[patterns.length][]);
        this.psubscribe(jedisPubSub, arrayOfPatterns);
    }

    public Long publish(byte[] channel, byte[] message) {
        return this.pubSubServerOperations.publish(channel, message);
    }

    public Long publish(String channel, String message) {
        return this.publish((byte[])this.toByteArray().convert((Object)channel), (byte[])this.toByteArray().convert((Object)message));
    }

    public Long lpushx(byte[] key, byte[] value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "list");
        return this.listDatatypeOperations.lpushx(key, value);
    }

    public Long rpushx(byte[] key, byte[] value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "list");
        return this.listDatatypeOperations.rpushx(key, value);
    }

    public Boolean setbit(byte[] key, long offset, byte[] value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        return this.stringDatatypeOperations.setbit(key, offset, value);
    }

    public Boolean getbit(byte[] key, long offset) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        return this.stringDatatypeOperations.getbit(key, offset);
    }

    public Long setrange(byte[] key, long offset, byte[] value) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        return this.stringDatatypeOperations.setrange(key, offset, value);
    }

    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        this.updateTtl(key);
        this.checkValidTypeOrNone(key, "string");
        return this.stringDatatypeOperations.getrange(key, startOffset, endOffset);
    }

    public Long dbSize() {
        this.updateAllTtlTimes();
        return this.keysServerOperations.dbSize();
    }

    public String flushDB() {
        return this.keysServerOperations.flushDB();
    }

    public String flushAll() {
        return this.flushDB();
    }

    public Long del(byte[] ... keys) {
        return this.keysServerOperations.del(keys);
    }

    public Long del(String ... keys) {
        byte[][] arrayOfFields = (byte[][])LambdaCollections.with((Object[])keys).convert(this.toByteArray()).toArray((Object[])new byte[keys.length][]);
        return this.del(arrayOfFields);
    }

    public String rename(String oldkey, String newkey) {
        return this.rename((byte[])this.toByteArray().convert((Object)oldkey), (byte[])this.toByteArray().convert((Object)newkey));
    }

    public String rename(byte[] oldkey, byte[] newkey) {
        this.updateTtl(oldkey);
        this.updateTtl(newkey);
        return this.keysServerOperations.rename(oldkey, newkey);
    }

    public Long renamenx(byte[] oldkey, byte[] newkey) {
        this.updateTtl(oldkey);
        this.updateTtl(newkey);
        return this.keysServerOperations.renamenx(oldkey, newkey);
    }

    public Set<byte[]> keys(byte[] pattern) {
        this.updateAllTtlTimes();
        return this.keysServerOperations.keys(pattern);
    }

    public Set<String> keys(String pattern) {
        Set<byte[]> result = this.keys((byte[])this.toByteArray().convert((Object)pattern));
        return new LinkedHashSet<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public Long persist(String key) {
        return this.persist((byte[])this.toByteArray().convert((Object)key));
    }

    public Long persist(byte[] key) {
        this.updateTtl(key);
        return this.keysServerOperations.persist(key);
    }

    public Long renamenx(String oldkey, String newkey) {
        return this.renamenx((byte[])this.toByteArray().convert((Object)oldkey), (byte[])this.toByteArray().convert((Object)newkey));
    }

    public Long move(byte[] key, int dbIndex) {
        return this.move(key, dbIndex);
    }

    public String set(String key, String value) {
        return this.set((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)value));
    }

    public String get(String key) {
        byte[] result = this.get((byte[])this.toByteArray().convert((Object)key));
        return (String)this.toStringValue().convert((Object)result);
    }

    public Boolean exists(String key) {
        return this.exists((byte[])this.toByteArray().convert((Object)key));
    }

    public String type(String key) {
        return this.type((byte[])this.toByteArray().convert((Object)key));
    }

    public Long expire(String key, int seconds) {
        return this.expire((byte[])this.toByteArray().convert((Object)key), seconds);
    }

    public Long expireAt(String key, long unixTime) {
        return this.expireAt((byte[])this.toByteArray().convert((Object)key), unixTime);
    }

    public Long ttl(String key) {
        return this.ttl((byte[])this.toByteArray().convert((Object)key));
    }

    public Boolean setbit(String key, long offset, boolean value) {
        return this.setbit((byte[])this.toByteArray().convert((Object)key), offset, (byte[])this.toBooleanByteArray().convert((Object)value));
    }

    public Boolean getbit(String key, long offset) {
        return this.getbit((byte[])this.toByteArray().convert((Object)key), offset);
    }

    public Long setrange(String key, long offset, String value) {
        return this.setrange((byte[])this.toByteArray().convert((Object)key), offset, (byte[])this.toByteArray().convert((Object)value));
    }

    public String getrange(String key, long startOffset, long endOffset) {
        byte[] result = this.getrange((byte[])this.toByteArray().convert((Object)key), startOffset, endOffset);
        return (String)this.toStringValue().convert((Object)result);
    }

    public String getSet(String key, String value) {
        byte[] result = this.getSet((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)value));
        return (String)this.toStringValue().convert((Object)result);
    }

    public Long setnx(String key, String value) {
        return this.setnx((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)value));
    }

    public String setex(String key, int seconds, String value) {
        return this.setex((byte[])this.toByteArray().convert((Object)key), seconds, (byte[])this.toByteArray().convert((Object)value));
    }

    public Long decrBy(String key, long integer) {
        return this.decrBy((byte[])this.toByteArray().convert((Object)key), integer);
    }

    public Long decr(String key) {
        return this.decr((byte[])this.toByteArray().convert((Object)key));
    }

    public Long incrBy(String key, long integer) {
        return this.incrBy((byte[])this.toByteArray().convert((Object)key), integer);
    }

    public Long incr(String key) {
        return this.incr((byte[])this.toByteArray().convert((Object)key));
    }

    public Long append(String key, String value) {
        return this.append((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)value));
    }

    public String substr(String key, int start, int end) {
        byte[] result = this.substr((byte[])this.toByteArray().convert((Object)key), start, end);
        return (String)this.toStringValue().convert((Object)result);
    }

    public Long hset(String key, String field, String value) {
        return this.hset((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)field), (byte[])this.toByteArray().convert((Object)value));
    }

    public String hget(String key, String field) {
        byte[] result = this.hget((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)field));
        return (String)this.toStringValue().convert((Object)result);
    }

    public Long hsetnx(String key, String field, String value) {
        return this.hsetnx((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)field), (byte[])this.toByteArray().convert((Object)value));
    }

    public String hmset(String key, Map<String, String> hash) {
        return this.hmset((byte[])this.toByteArray().convert((Object)key), (Map)this.toMapByteArray().convert(hash));
    }

    public List<String> hmget(String key, String ... fields) {
        byte[][] arrayOfFields = (byte[][])LambdaCollections.with((Object[])fields).convert(this.toByteArray()).toArray((Object[])new byte[fields.length][]);
        List<byte[]> result = this.hmget((byte[])this.toByteArray().convert((Object)key), arrayOfFields);
        return LambdaCollections.with(result).convert(this.toStringValue());
    }

    public Long hincrBy(String key, String field, long value) {
        return this.hincrBy((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)field), value);
    }

    public Boolean hexists(String key, String field) {
        return this.hexists((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)field));
    }

    public Long hdel(String key, String ... fields) {
        byte[][] arrayOfFields = (byte[][])LambdaCollections.with((Object[])fields).convert(this.toByteArray()).toArray((Object[])new byte[fields.length][]);
        return this.hdel((byte[])this.toByteArray().convert((Object)key), arrayOfFields);
    }

    public Long hlen(String key) {
        return this.hlen((byte[])this.toByteArray().convert((Object)key));
    }

    public Set<String> hkeys(String key) {
        Set<byte[]> result = this.hkeys((byte[])this.toByteArray().convert((Object)key));
        return new LinkedHashSet<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public List<String> hvals(String key) {
        Collection<byte[]> result = this.hvals((byte[])this.toByteArray().convert((Object)key));
        return new LinkedList<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public Map<String, String> hgetAll(String key) {
        Map<byte[], byte[]> result = this.hgetAll((byte[])this.toByteArray().convert((Object)key));
        return (Map)this.toMapString().convert(result);
    }

    public Long rpush(String key, String ... fields) {
        byte[][] arrayOfFields = (byte[][])LambdaCollections.with((Object[])fields).convert(this.toByteArray()).toArray((Object[])new byte[fields.length][]);
        return this.rpush((byte[])this.toByteArray().convert((Object)key), arrayOfFields);
    }

    public Long lpush(String key, String ... fields) {
        byte[][] arrayOfFields = (byte[][])LambdaCollections.with((Object[])fields).convert(this.toByteArray()).toArray((Object[])new byte[fields.length][]);
        return this.lpush((byte[])this.toByteArray().convert((Object)key), arrayOfFields);
    }

    public Long llen(String key) {
        return this.llen((byte[])this.toByteArray().convert((Object)key));
    }

    public List<String> lrange(String key, long start, long end) {
        List<byte[]> result = this.lrange((byte[])this.toByteArray().convert((Object)key), (int)start, (int)end);
        return LambdaCollections.with(result).convert(this.toStringValue());
    }

    public String ltrim(String key, long start, long end) {
        return this.ltrim((byte[])this.toByteArray().convert((Object)key), (int)start, (int)end);
    }

    public String lindex(String key, long index) {
        byte[] result = this.lindex((byte[])this.toByteArray().convert((Object)key), (int)index);
        return (String)this.toStringValue().convert((Object)result);
    }

    public String lset(String key, long index, String value) {
        return this.lset((byte[])this.toByteArray().convert((Object)key), (int)index, (byte[])this.toByteArray().convert((Object)value));
    }

    public Long lrem(String key, long count, String value) {
        return this.lrem((byte[])this.toByteArray().convert((Object)key), (int)count, (byte[])this.toByteArray().convert((Object)value));
    }

    public String lpop(String key) {
        byte[] result = this.lpop((byte[])this.toByteArray().convert((Object)key));
        return (String)this.toStringValue().convert((Object)result);
    }

    public String rpop(String key) {
        byte[] result = this.rpop((byte[])this.toByteArray().convert((Object)key));
        return (String)this.toStringValue().convert((Object)result);
    }

    public Long sadd(String key, String ... members) {
        byte[][] arrayOfFields = (byte[][])LambdaCollections.with((Object[])members).convert(this.toByteArray()).toArray((Object[])new byte[members.length][]);
        return this.sadd((byte[])this.toByteArray().convert((Object)key), arrayOfFields);
    }

    public Set<String> smembers(String key) {
        Set<byte[]> result = this.smembers((byte[])this.toByteArray().convert((Object)key));
        return new LinkedHashSet<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public Long srem(String key, String ... members) {
        byte[][] arrayOfFields = (byte[][])LambdaCollections.with((Object[])members).convert(this.toByteArray()).toArray((Object[])new byte[members.length][]);
        return this.srem((byte[])this.toByteArray().convert((Object)key), arrayOfFields);
    }

    public String spop(String key) {
        byte[] result = this.spop((byte[])this.toByteArray().convert((Object)key));
        return (String)this.toStringValue().convert((Object)result);
    }

    public Long scard(String key) {
        return this.scard((byte[])this.toByteArray().convert((Object)key));
    }

    public Boolean sismember(String key, String member) {
        return this.sismember((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)member));
    }

    public String srandmember(String key) {
        byte[] result = this.srandmember((byte[])this.toByteArray().convert((Object)key));
        return (String)this.toStringValue().convert((Object)result);
    }

    public Long zadd(String key, double score, String member) {
        return this.zadd((byte[])this.toByteArray().convert((Object)key), score, (byte[])this.toByteArray().convert((Object)member));
    }

    public Long zadd(String key, Map<Double, String> scoreMembers) {
        return this.zadd((byte[])this.toByteArray().convert((Object)key), (Map<Double, byte[]>)LambdaCollections.with(scoreMembers).convertValues(this.toByteArray()));
    }

    public Set<String> zrange(String key, long start, long end) {
        Set<byte[]> result = this.zrange((byte[])this.toByteArray().convert((Object)key), (int)start, (int)end);
        return new LinkedHashSet<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public Long zrem(String key, String ... members) {
        byte[][] arrayOfFields = (byte[][])LambdaCollections.with((Object[])members).convert(this.toByteArray()).toArray((Object[])new byte[members.length][]);
        return this.zrem((byte[])this.toByteArray().convert((Object)key), arrayOfFields);
    }

    public Double zincrby(String key, double score, String member) {
        return this.zincrby((byte[])this.toByteArray().convert((Object)key), score, (byte[])this.toByteArray().convert((Object)member));
    }

    public Long zrank(String key, String member) {
        return this.zrank((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)member));
    }

    public Long zrevrank(String key, String member) {
        return this.zrevrank((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)member));
    }

    public Set<String> zrevrange(String key, long start, long end) {
        Set<byte[]> result = this.zrevrange((byte[])this.toByteArray().convert((Object)key), (int)start, (int)end);
        return new LinkedHashSet<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        return this.zrangeWithScores((byte[])this.toByteArray().convert((Object)key), (int)start, (int)end);
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        return this.zrevrangeWithScores((byte[])this.toByteArray().convert((Object)key), (int)start, (int)end);
    }

    public Long zcard(String key) {
        return this.zcard((byte[])this.toByteArray().convert((Object)key));
    }

    public Double zscore(String key, String member) {
        return this.zscore((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)member));
    }

    public List<String> sort(String key) {
        List<byte[]> result = this.sort((byte[])this.toByteArray().convert((Object)key));
        return LambdaCollections.with(result).convert(this.toStringValue());
    }

    public List<String> sort(String key, SortingParams sortingParameters) {
        List<byte[]> result = this.sort((byte[])this.toByteArray().convert((Object)key), sortingParameters);
        return LambdaCollections.with(result).convert(this.toStringValue());
    }

    public Long zcount(String key, double min, double max) {
        return this.zcount((byte[])this.toByteArray().convert((Object)key), min, max);
    }

    public Long zcount(String key, String min, String max) {
        return this.zcount((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)min), (byte[])this.toByteArray().convert((Object)max));
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        Set<byte[]> result = this.zrangeByScore((byte[])this.toByteArray().convert((Object)key), min, max);
        return new LinkedHashSet<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        Set<byte[]> result = this.zrangeByScore((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)min), (byte[])this.toByteArray().convert((Object)max));
        return new LinkedHashSet<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public Set<String> zrevrangeByScore(String key, double max, double min) {
        Set<byte[]> result = this.zrevrangeByScore((byte[])this.toByteArray().convert((Object)key), max, min);
        return new LinkedHashSet<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        Set<byte[]> result = this.zrangeByScore((byte[])this.toByteArray().convert((Object)key), min, max, offset, count);
        return new LinkedHashSet<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public Set<String> zrevrangeByScore(String key, String max, String min) {
        Set<byte[]> result = this.zrevrangeByScore((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)max), (byte[])this.toByteArray().convert((Object)min));
        return new LinkedHashSet<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        Set<byte[]> result = this.zrangeByScore((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)min), (byte[])this.toByteArray().convert((Object)max), offset, count);
        return new LinkedHashSet<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        Set<byte[]> result = this.zrevrangeByScore((byte[])this.toByteArray().convert((Object)key), max, min, offset, count);
        return new LinkedHashSet<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        return this.zrangeByScoreWithScores((byte[])this.toByteArray().convert((Object)key), min, max);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        return this.zrevrangeByScoreWithScores((byte[])this.toByteArray().convert((Object)key), max, min);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        return this.zrangeByScoreWithScores((byte[])this.toByteArray().convert((Object)key), min, max, offset, count);
    }

    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        Set<byte[]> result = this.zrevrangeByScore((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)max), (byte[])this.toByteArray().convert((Object)min), offset, count);
        return new LinkedHashSet<String>((Collection<String>)LambdaCollections.with(result).convert(this.toStringValue()));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        return this.zrangeByScoreWithScores((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)min), (byte[])this.toByteArray().convert((Object)max));
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        return this.zrevrangeByScoreWithScores((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)max), (byte[])this.toByteArray().convert((Object)min));
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        return this.zrangeByScoreWithScores((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)min), (byte[])this.toByteArray().convert((Object)max), offset, count);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        return this.zrevrangeByScoreWithScores((byte[])this.toByteArray().convert((Object)key), max, min, offset, count);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        return this.zrevrangeByScoreWithScores((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)max), (byte[])this.toByteArray().convert((Object)min), offset, count);
    }

    public Long zremrangeByRank(String key, long start, long end) {
        return this.zremrangeByRank((byte[])this.toByteArray().convert((Object)key), (int)start, (int)end);
    }

    public Long zremrangeByScore(String key, double start, double end) {
        return this.zremrangeByScore((byte[])this.toByteArray().convert((Object)key), start, end);
    }

    public Long zremrangeByScore(String key, String start, String end) {
        return this.zremrangeByScore((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)start), (byte[])this.toByteArray().convert((Object)end));
    }

    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        return this.linsert((byte[])this.toByteArray().convert((Object)key), where, (byte[])this.toByteArray().convert((Object)pivot), (byte[])this.toByteArray().convert((Object)value));
    }

    public Long lpushx(String key, String string) {
        return this.lpushx((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)string));
    }

    public Long rpushx(String key, String string) {
        return this.rpushx((byte[])this.toByteArray().convert((Object)key), (byte[])this.toByteArray().convert((Object)string));
    }

    public String auth(String password) {
        return this.connectionServerOperations.auth(password);
    }

    public byte[] echo(byte[] string) {
        return this.connectionServerOperations.echo(string);
    }

    public String echo(String string) {
        byte[] result = this.echo((byte[])this.toByteArray().convert((Object)string));
        return (String)this.toStringValue().convert((Object)result);
    }

    public String ping() {
        return this.connectionServerOperations.ping();
    }

    public String quit() {
        return this.connectionServerOperations.quit();
    }

    public String select(int index) {
        return this.connectionServerOperations.select(index);
    }

    public Object eval(byte[] script, List<byte[]> keys, List<byte[]> args) {
        return this.scriptingServerOperations.eval(script, keys, args);
    }

    public Object eval(byte[] script, byte[] keyCount, byte[][] params) {
        return this.scriptingServerOperations.eval(script, keyCount, params);
    }

    public Object eval(String script, int keyCount, String ... params) {
        byte[][] arrayOfParams = (byte[][])LambdaCollections.with((Object[])params).convert(this.toByteArray()).toArray((Object[])new byte[params.length][]);
        return this.eval((byte[])this.toByteArray().convert((Object)script), (byte[])this.toByteArray().convert((Object)Integer.toString(keyCount)), arrayOfParams);
    }

    public Object eval(String script, List<String> keys, List<String> args) {
        return this.eval((byte[])this.toByteArray().convert((Object)script), (List<byte[]>)LambdaCollections.with(keys).convert(this.toByteArray()), (List<byte[]>)LambdaCollections.with(args).convert(this.toByteArray()));
    }

    public Object eval(String script) {
        return this.eval(script, 0, new String[0]);
    }

    public Object evalsha(String script) {
        return this.evalsha(script, 0, new String[0]);
    }

    public Object evalsha(String sha1, List<String> keys, List<String> args) {
        return this.evalsha(sha1, keys.size(), this.getParams(keys, args));
    }

    public Object evalsha(String sha1, int keyCount, String ... params) {
        return this.evalsha((byte[])this.toByteArray().convert((Object)sha1), (byte[])this.toByteArray().convert((Object)Integer.toString(keyCount)), (byte[][])LambdaCollections.with((Object[])params).convert(this.toByteArray()).toArray((Object[])new byte[params.length][]));
    }

    public Object evalsha(byte[] sha1, byte[] keyCount, byte[] ... params) {
        return this.scriptingServerOperations.evalsha(sha1, keyCount, params);
    }

    private String[] getParams(List<String> keys, List<String> args) {
        int i;
        int keyCount = keys.size();
        int argCount = args.size();
        String[] params = new String[keyCount + args.size()];
        for (i = 0; i < keyCount; ++i) {
            params[i] = keys.get(i);
        }
        for (i = 0; i < argCount; ++i) {
            params[keyCount + i] = args.get(i);
        }
        return params;
    }

    public List<Long> scriptExists(byte[] ... sha1) {
        return this.scriptingServerOperations.scriptExists(sha1);
    }

    public Boolean scriptExists(String sha1) {
        String[] a = new String[]{sha1};
        return this.scriptExists(a).get(0);
    }

    public List<Boolean> scriptExists(String ... sha1) {
        throw new UnsupportedOperationException("script Exists is not supported");
    }

    public byte[] scriptFlush() {
        return this.scriptingServerOperations.scriptFlush();
    }

    public byte[] scriptKill() {
        return this.scriptingServerOperations.scriptKill();
    }

    public byte[] scriptLoad(byte[] script) {
        return this.scriptingServerOperations.scriptLoad(script);
    }

    public String scriptLoad(String script) {
        byte[] result = this.scriptLoad((byte[])this.toByteArray().convert((Object)script));
        return (String)this.toStringValue().convert((Object)result);
    }

    public String watch(byte[] ... keys) {
        return this.transactionServerOperations.watch(keys);
    }

    public String watch(String ... keys) {
        return this.watch((byte[][])LambdaCollections.with((Object[])keys).convert(this.toByteArray()).toArray((Object[])new byte[keys.length][]));
    }

    public String unwatch() {
        return this.transactionServerOperations.unwatch();
    }

    public List<Object> pipelined(PipelineBlock jedisPipeline) {
        return this.transactionServerOperations.pipelined(jedisPipeline);
    }

    public Pipeline pipelined() {
        return this.transactionServerOperations.pipelined();
    }

    public String bgrewriteaof() {
        return this.keysServerOperations.bgrewriteaof();
    }

    public String save() {
        return this.keysServerOperations.save();
    }

    public String bgsave() {
        return this.keysServerOperations.bgsave();
    }

    public List<byte[]> configGet(byte[] pattern) {
        return this.keysServerOperations.configGet(pattern);
    }

    public List<String> configGet(String pattern) {
        List<byte[]> result = this.configGet((byte[])this.toByteArray().convert((Object)pattern));
        return LambdaCollections.with(result).convert(this.toStringValue());
    }

    public byte[] configSet(byte[] parameter, byte[] value) {
        return this.keysServerOperations.configSet(parameter, value);
    }

    public String configSet(String parameter, String value) {
        byte[] result = this.configSet((byte[])this.toByteArray().convert((Object)parameter), (byte[])this.toByteArray().convert((Object)value));
        return (String)this.toStringValue().convert((Object)result);
    }

    public String configResetStat() {
        return this.keysServerOperations.configResetStat();
    }

    public String info() {
        return this.keysServerOperations.info();
    }

    public Long lastsave() {
        return this.keysServerOperations.lastsave();
    }

    public void monitor(JedisMonitor jedisMonitor) {
        this.keysServerOperations.monitor(jedisMonitor);
    }

    public String shutdown() {
        return this.keysServerOperations.shutdown();
    }

    public String slaveof(String host, int port) {
        return this.keysServerOperations.slaveof(host, port);
    }

    public String slaveofNoOne() {
        return this.keysServerOperations.slaveofNoOne();
    }

    public List<Slowlog> slowlogGet() {
        return this.keysServerOperations.slowlogGet();
    }

    public List<Slowlog> slowlogGet(long entries) {
        return this.keysServerOperations.slowlogGet(entries);
    }

    public byte[] slowlogReset() {
        return this.keysServerOperations.slowlogReset();
    }

    public long slowlogLen() {
        return this.keysServerOperations.slowlogLen();
    }

    public List<byte[]> slowlogGetBinary() {
        return this.keysServerOperations.slowlogGetBinary();
    }

    public List<byte[]> slowlogGetBinary(long entries) {
        return this.keysServerOperations.slowlogGetBinary(entries);
    }

    public void sync() {
        this.keysServerOperations.sync();
    }

    public Long time() {
        return this.keysServerOperations.time();
    }

    public Long getDB() {
        return this.keysServerOperations.getDB();
    }

    public boolean isConnected() {
        return this.keysServerOperations.isConnected();
    }

    public Transaction multi() {
        return this.transactionServerOperations.multi();
    }

    public List<Object> multi(TransactionBlock jedisTransaction) {
        return this.transactionServerOperations.multi(jedisTransaction);
    }

    private void checkValidTypeOrNone(byte[] key, String type) {
        String currentType = this.keysServerOperations.type(key);
        if (!"none".equals(currentType) && !currentType.equals(type)) {
            throw new IllegalArgumentException("ERR Operation against a key holding the wrong kind of value");
        }
    }

    private void updateAllTtlTimes() {
        this.keysServerOperations.updateTtl();
    }

    private void updateTtl(byte[] key) {
        this.keysServerOperations.updateTtl(key);
    }

    private Converter<SortsetDatatypeOperations.ScoredByteBuffer, Tuple> toTuple() {
        return new Converter<SortsetDatatypeOperations.ScoredByteBuffer, Tuple>(){

            public Tuple convert(SortsetDatatypeOperations.ScoredByteBuffer from) {
                return new Tuple(from.getByteBuffer().array(), Double.valueOf(from.getScore()));
            }
        };
    }

    private Converter<BinaryClient.LIST_POSITION, ListDatatypeOperations.ListPositionEnum> toListPosition() {
        return new Converter<BinaryClient.LIST_POSITION, ListDatatypeOperations.ListPositionEnum>(){

            public ListDatatypeOperations.ListPositionEnum convert(BinaryClient.LIST_POSITION from) {
                switch (from) {
                    case BEFORE: {
                        return ListDatatypeOperations.ListPositionEnum.BEFORE;
                    }
                    case AFTER: {
                        return ListDatatypeOperations.ListPositionEnum.AFTER;
                    }
                }
                return ListDatatypeOperations.ListPositionEnum.BEFORE;
            }
        };
    }

    private Converter<Boolean, byte[]> toBooleanByteArray() {
        return new Converter<Boolean, byte[]>(){

            public byte[] convert(Boolean from) {
                if (from.booleanValue()) {
                    return "1".getBytes();
                }
                return "0".getBytes();
            }
        };
    }

    private Converter<Map<byte[], byte[]>, Map<String, String>> toMapString() {
        return new Converter<Map<byte[], byte[]>, Map<String, String>>(){

            public Map<String, String> convert(Map<byte[], byte[]> from) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(from.size());
                Set<byte[]> keySet = from.keySet();
                for (byte[] key : keySet) {
                    map.put((String)EmbeddedJedis.this.toStringValue().convert((Object)key), (String)EmbeddedJedis.this.toStringValue().convert((Object)from.get(key)));
                }
                return map;
            }
        };
    }

    private Converter<Map<String, String>, Map<byte[], byte[]>> toMapByteArray() {
        return new Converter<Map<String, String>, Map<byte[], byte[]>>(){

            public Map<byte[], byte[]> convert(Map<String, String> from) {
                LinkedHashMap<byte[], byte[]> map = new LinkedHashMap<byte[], byte[]>(from.size());
                Set<String> keySet = from.keySet();
                for (String key : keySet) {
                    map.put((byte[])EmbeddedJedis.this.toByteArray().convert((Object)key), (byte[])EmbeddedJedis.this.toByteArray().convert((Object)from.get(key)));
                }
                return map;
            }
        };
    }

    private Converter<byte[], String> toStringValue() {
        return BYTE_ARRAY_TO_STRING_CONVERTER;
    }

    private Converter<String, byte[]> toByteArray() {
        return STRING_TO_BYTE_ARRAY_CONVERTER;
    }
}

