/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.embedded;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.lordofthejars.nosqlunit.redis.embedded.BlockingMap;
import com.lordofthejars.nosqlunit.redis.embedded.ByteArray2ByteBufferConverter;
import com.lordofthejars.nosqlunit.redis.embedded.ByteBuffer2ByteArrayConverter;
import com.lordofthejars.nosqlunit.redis.embedded.ByteBufferAsString2DoubleConverter;
import com.lordofthejars.nosqlunit.redis.embedded.DoubleToStringByteArrayConverter;
import com.lordofthejars.nosqlunit.redis.embedded.ExpirationDatatypeOperations;
import com.lordofthejars.nosqlunit.redis.embedded.RangeUtils;
import com.lordofthejars.nosqlunit.redis.embedded.RedisDatatypeOperations;
import com.lordofthejars.nosqlunit.redis.embedded.TransferMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ListDatatypeOperations
extends ExpirationDatatypeOperations
implements RedisDatatypeOperations {
    protected static final String LIST = "list";
    private static final String KO = "-";
    private static final String OK = "OK";
    protected BlockingMap<ByteBuffer, ByteBuffer> blockingMultimap = TransferMap.create();

    public List<byte[]> blpop(int timeout, byte[] ... keys) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        List<Callable<KeyMembers>> popActions = Collections.EMPTY_LIST;
        popActions = timeout == 0 ? this.addFuturePopWithoutTimeout(countDownLatch, keys) : this.addFuturePopWithTimeout(countDownLatch, timeout, keys);
        return this.executeFutureTasksWaitingForData(executorService, countDownLatch, popActions);
    }

    public byte[] brpoplpush(byte[] source, byte[] destination, int timeout) {
        List<byte[]> element = this.brpop(timeout, new byte[][]{source});
        if (element != null) {
            this.lpush(destination, new byte[][]{element.get(1)});
            return element.get(1);
        }
        return null;
    }

    public Long linsert(byte[] key, ListPositionEnum where, byte[] pivot, byte[] value) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        if (this.blockingMultimap.containsKey(wrappedKey)) {
            int index = this.blockingMultimap.indexOf(wrappedKey, ByteBuffer.wrap(pivot));
            if (this.isPivotFound(index)) {
                this.blockingMultimap.addElementAt(wrappedKey, ByteBuffer.wrap(value), this.calculateIndexPosition(index, where));
                return this.blockingMultimap.size(wrappedKey);
            }
            return -1L;
        }
        return 0L;
    }

    public byte[] lpop(byte[] key) {
        ByteBuffer polledElement = this.blockingMultimap.pollFirst(ByteBuffer.wrap(key));
        return polledElement == null ? null : polledElement.array();
    }

    public byte[] rpop(byte[] key) {
        ByteBuffer polledElement = this.blockingMultimap.pollLast(ByteBuffer.wrap(key));
        return polledElement == null ? null : polledElement.array();
    }

    public Long llen(byte[] key) {
        return this.blockingMultimap.size(ByteBuffer.wrap(key));
    }

    public String lset(byte[] key, int index, byte[] value) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        long numberOfElements = this.blockingMultimap.size(wrappedKey);
        int realIndex = index;
        if (realIndex < 0) {
            realIndex = (int)(numberOfElements + (long)index);
        }
        try {
            this.blockingMultimap.remove(wrappedKey, realIndex);
            ByteBuffer insertedValue = this.blockingMultimap.addElementAt(wrappedKey, ByteBuffer.wrap(value), realIndex);
            if (insertedValue == null) {
                return KO;
            }
        }
        catch (IndexOutOfBoundsException e) {
            return KO;
        }
        return OK;
    }

    private boolean isPivotFound(int index) {
        return index != -1;
    }

    private int calculateIndexPosition(int index, ListPositionEnum where) {
        switch (where) {
            case BEFORE: {
                return index;
            }
            case AFTER: {
                return index + 1;
            }
        }
        return index;
    }

    public byte[] lindex(byte[] key, int index) {
        ByteBuffer elementAtIndex = this.blockingMultimap.getElement(ByteBuffer.wrap(key), index);
        return elementAtIndex == null ? null : elementAtIndex.array();
    }

    public List<byte[]> brpop(int timeout, byte[] ... keys) {
        ExecutorService executorService = Executors.newCachedThreadPool();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        List<Callable<KeyMembers>> popActions = Collections.EMPTY_LIST;
        popActions = timeout == 0 ? this.addFutureLastPopWithoutTimeout(countDownLatch, keys) : this.addFutureLastPopWithTimeout(countDownLatch, timeout, keys);
        return this.executeFutureTasksWaitingForData(executorService, countDownLatch, popActions);
    }

    public Long lpush(byte[] key, byte[] ... values) {
        List elements = Lambda.convert((Object)values, (Converter)new ByteArray2ByteBufferConverter());
        this.blockingMultimap.putFirst(ByteBuffer.wrap(key), elements);
        return this.blockingMultimap.size(ByteBuffer.wrap(key));
    }

    public Long lpushx(byte[] key, byte[] value) {
        if (this.blockingMultimap.containsKey(ByteBuffer.wrap(key))) {
            return this.lpush(key, new byte[][]{value});
        }
        return this.blockingMultimap.size(ByteBuffer.wrap(key));
    }

    public Long rpushx(byte[] key, byte[] value) {
        if (this.blockingMultimap.containsKey(ByteBuffer.wrap(key))) {
            return this.rpush(key, new byte[][]{value});
        }
        return this.blockingMultimap.size(ByteBuffer.wrap(key));
    }

    public List<byte[]> lrange(byte[] key, int start, int end) {
        LinkedList<ByteBuffer> elements = new LinkedList<ByteBuffer>(this.blockingMultimap.elements(ByteBuffer.wrap(key)));
        int calculatedStart = RangeUtils.calculateStart(start, elements.size());
        int calculatedEnd = RangeUtils.calculateEnd(end, elements.size());
        try {
            List subList = elements.subList(calculatedStart, calculatedEnd);
            return Lambda.convert(subList, (Converter)new ByteBuffer2ByteArrayConverter());
        }
        catch (IndexOutOfBoundsException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public Long rpush(byte[] key, byte[] ... values) {
        List elements = Lambda.convert((Object)values, (Converter)new ByteArray2ByteBufferConverter());
        this.blockingMultimap.putLast(ByteBuffer.wrap(key), elements);
        return this.blockingMultimap.size(ByteBuffer.wrap(key));
    }

    public Long lrem(byte[] key, int count, byte[] value) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        ByteBuffer wrappedValue = ByteBuffer.wrap(value);
        long numberOfElementsRemoved = 0L;
        numberOfElementsRemoved = count < 0 ? this.removeLastElements(count, wrappedKey, wrappedValue) : (count == 0 ? this.removeAllElements(wrappedKey, wrappedValue) : this.removeFirstElements(count, wrappedKey, wrappedValue));
        return numberOfElementsRemoved;
    }

    public String ltrim(byte[] key, int start, int end) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        LinkedList<ByteBuffer> elements = new LinkedList<ByteBuffer>(this.blockingMultimap.elements(wrappedKey));
        int calculatedStart = RangeUtils.calculateStart(start, elements.size());
        int calculatedEnd = RangeUtils.calculateEnd(end, elements.size());
        try {
            List sublist = elements.subList(calculatedStart, calculatedEnd);
            this.blockingMultimap.replaceValues(wrappedKey, sublist);
        }
        catch (IndexOutOfBoundsException e) {
            return KO;
        }
        catch (IllegalArgumentException e) {
            return KO;
        }
        return OK;
    }

    @Override
    public long getNumberOfKeys() {
        return this.blockingMultimap.size();
    }

    @Override
    public void flushAllKeys() {
        this.removeExpirations();
        this.blockingMultimap.clear();
    }

    private void removeExpirations() {
        List<byte[]> keys = this.keys();
        for (byte[] key : keys) {
            this.removeExpiration(key);
        }
    }

    private long removeFirstElements(int count, ByteBuffer wrappedKey, ByteBuffer wrappedValue) {
        int indexOf;
        long numberOfElementsRemoved = 0L;
        for (int numberOfElements = this.numberOfElementsToRemove(count); numberOfElements > 0 && (indexOf = this.blockingMultimap.indexOf(wrappedKey, wrappedValue)) != -1; --numberOfElements) {
            this.blockingMultimap.remove(wrappedKey, indexOf);
            ++numberOfElementsRemoved;
        }
        return numberOfElementsRemoved;
    }

    private long removeAllElements(ByteBuffer wrappedKey, ByteBuffer wrappedValue) {
        long numberOfElementsRemoved = 0L;
        int indexOf = this.blockingMultimap.indexOf(wrappedKey, wrappedValue);
        while (indexOf != -1) {
            this.blockingMultimap.remove(wrappedKey, indexOf);
            ++numberOfElementsRemoved;
            indexOf = this.blockingMultimap.indexOf(wrappedKey, wrappedValue);
        }
        return numberOfElementsRemoved;
    }

    private long removeLastElements(int count, ByteBuffer wrappedKey, ByteBuffer wrappedValue) {
        int indexOf;
        long numberOfElementsRemoved = 0L;
        for (int numberOfElements = this.numberOfElementsToRemove(count); numberOfElements > 0 && (indexOf = this.blockingMultimap.lastIndexOf(wrappedKey, wrappedValue)) != -1; --numberOfElements) {
            this.blockingMultimap.remove(wrappedKey, indexOf);
            ++numberOfElementsRemoved;
        }
        return numberOfElementsRemoved;
    }

    private int numberOfElementsToRemove(int count) {
        return Math.abs(count);
    }

    private List<byte[]> executeFutureTasksWaitingForData(ExecutorService executorService, CountDownLatch countDownLatch, List<Callable<KeyMembers>> popActions) {
        LinkedList<Future<KeyMembers>> futures = new LinkedList<Future<KeyMembers>>();
        for (Callable<KeyMembers> callable : popActions) {
            futures.add(executorService.submit(callable));
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            return null;
        }
        executorService.shutdownNow();
        try {
            Future<KeyMembers> futureWithValidKey = this.findFirstFutureWithValidData(futures);
            if (futureWithValidKey != null) {
                KeyMembers elements = futureWithValidKey.get();
                ByteBuffer membersOfKey = elements.getValue();
                if (membersOfKey != null) {
                    ArrayList<byte[]> keyMember = new ArrayList<byte[]>();
                    keyMember.add(elements.getKey().array());
                    keyMember.add(membersOfKey.array());
                    return keyMember;
                }
                return null;
            }
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
        return null;
    }

    private Future<KeyMembers> findFirstFutureWithValidData(List<Future<KeyMembers>> futures) throws InterruptedException, ExecutionException {
        for (Future<KeyMembers> future : futures) {
            if (future == null || future.get().getValue() == null) continue;
            return future;
        }
        return null;
    }

    private List<Callable<KeyMembers>> addFutureLastPopWithoutTimeout(final CountDownLatch countDownLatch, byte[] ... keys) {
        LinkedList<Callable<KeyMembers>> futureTasks = new LinkedList<Callable<KeyMembers>>();
        for (final byte[] key : keys) {
            futureTasks.add(new Callable<KeyMembers>(){

                @Override
                public KeyMembers call() throws Exception {
                    ByteBuffer result = ListDatatypeOperations.this.blockingMultimap.lastAndWait(ByteBuffer.wrap(key));
                    countDownLatch.countDown();
                    KeyMembers keyMembers = new KeyMembers(ByteBuffer.wrap(key), result);
                    return keyMembers;
                }
            });
        }
        return futureTasks;
    }

    private List<Callable<KeyMembers>> addFutureLastPopWithTimeout(final CountDownLatch countDownLatch, final int timeout, byte[] ... keys) {
        LinkedList<Callable<KeyMembers>> futureTasks = new LinkedList<Callable<KeyMembers>>();
        for (final byte[] key : keys) {
            futureTasks.add(new Callable<KeyMembers>(){

                @Override
                public KeyMembers call() throws Exception {
                    ByteBuffer result = ListDatatypeOperations.this.blockingMultimap.lastAndWait(ByteBuffer.wrap(key), timeout);
                    countDownLatch.countDown();
                    KeyMembers keyMembers = new KeyMembers(ByteBuffer.wrap(key), result);
                    return keyMembers;
                }
            });
        }
        return futureTasks;
    }

    private List<Callable<KeyMembers>> addFuturePopWithoutTimeout(final CountDownLatch countDownLatch, byte[] ... keys) {
        LinkedList<Callable<KeyMembers>> futureTasks = new LinkedList<Callable<KeyMembers>>();
        for (final byte[] key : keys) {
            futureTasks.add(new Callable<KeyMembers>(){

                @Override
                public KeyMembers call() throws Exception {
                    ByteBuffer result = ListDatatypeOperations.this.blockingMultimap.getAndWait(ByteBuffer.wrap(key));
                    countDownLatch.countDown();
                    KeyMembers keyMembers = new KeyMembers(ByteBuffer.wrap(key), result);
                    return keyMembers;
                }
            });
        }
        return futureTasks;
    }

    private List<Callable<KeyMembers>> addFuturePopWithTimeout(final CountDownLatch countDownLatch, final int timeout, byte[] ... keys) {
        LinkedList<Callable<KeyMembers>> futureTasks = new LinkedList<Callable<KeyMembers>>();
        for (final byte[] key : keys) {
            futureTasks.add(new Callable<KeyMembers>(){

                @Override
                public KeyMembers call() throws Exception {
                    ByteBuffer result = ListDatatypeOperations.this.blockingMultimap.getAndWait(ByteBuffer.wrap(key), timeout);
                    countDownLatch.countDown();
                    KeyMembers keyMembers = new KeyMembers(ByteBuffer.wrap(key), result);
                    return keyMembers;
                }
            });
        }
        return futureTasks;
    }

    @Override
    public Long del(byte[] ... keys) {
        long numberOfRemovedElements = 0L;
        for (byte[] key : keys) {
            ByteBuffer wrappedKey = ByteBuffer.wrap(key);
            if (!this.blockingMultimap.containsKey(wrappedKey)) continue;
            this.blockingMultimap.clear(wrappedKey);
            this.removeExpiration(key);
            ++numberOfRemovedElements;
        }
        return numberOfRemovedElements;
    }

    @Override
    public boolean exists(byte[] key) {
        return this.blockingMultimap.containsKey(ByteBuffer.wrap(key));
    }

    @Override
    public boolean renameKey(byte[] key, byte[] newKey) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        if (this.blockingMultimap.containsKey(wrappedKey)) {
            Collection<ByteBuffer> elements = this.blockingMultimap.elements(wrappedKey);
            this.blockingMultimap.clear(ByteBuffer.wrap(newKey));
            this.blockingMultimap.putLast(ByteBuffer.wrap(newKey), elements);
            this.blockingMultimap.clear(wrappedKey);
            this.renameTtlKey(key, newKey);
            return true;
        }
        return false;
    }

    @Override
    public List<byte[]> keys() {
        return new ArrayList<byte[]>(Lambda.convert(this.blockingMultimap.keySet(), (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter()));
    }

    @Override
    public String type() {
        return LIST;
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        try {
            return this.sortNumberValues(key);
        }
        catch (NumberFormatException e) {
            return Lambda.convert(this.blockingMultimap.elements(ByteBuffer.wrap(key)), (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter());
        }
    }

    private List<byte[]> sortNumberValues(byte[] key) {
        ArrayList values = new ArrayList(Lambda.convert(this.blockingMultimap.elements(ByteBuffer.wrap(key)), (Converter)ByteBufferAsString2DoubleConverter.createByteBufferAsStringToDoubleConverter()));
        Collections.sort(values);
        return new LinkedList<byte[]>(Lambda.convert(values, (Converter)DoubleToStringByteArrayConverter.createDoubleToStringByteArrayConverter()));
    }

    private final class KeyMembers {
        private ByteBuffer key;
        private ByteBuffer value;

        public KeyMembers(ByteBuffer key, ByteBuffer value) {
            this.key = key;
            this.value = value;
        }

        public ByteBuffer getKey() {
            return this.key;
        }

        public ByteBuffer getValue() {
            return this.value;
        }
    }

    public static enum ListPositionEnum {
        BEFORE,
        AFTER;

    }
}

