/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.embedded;

import ch.lambdaj.Lambda;
import com.lordofthejars.nosqlunit.redis.embedded.SortsetDatatypeOperations;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class RangeUtils {
    private static final String NEGATIVE_INFINITE = "-inf";
    private static final String POSITIVE_INFINITE = "+inf";
    private static final String EXCLUSIVE_SYMBOL = "(";

    private RangeUtils() {
    }

    public static byte[] concat(byte[] first, byte[] second) {
        byte[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static int calculateEnd(int end, int size) {
        if (end >= size) {
            return size;
        }
        if (end < 0) {
            return size + ++end;
        }
        return end + 1;
    }

    public static long calculateStart(long start, long size) {
        return start < 0L ? size + start : start;
    }

    public static int calculateStart(int start, int size) {
        return start < 0 ? size + start : start;
    }

    public static List<SortsetDatatypeOperations.ScoredByteBuffer> limitListByOffsetCount(int offset, int count, List<SortsetDatatypeOperations.ScoredByteBuffer> elements) {
        if (offset >= elements.size()) {
            return Collections.EMPTY_LIST;
        }
        return elements.subList(offset, RangeUtils.endIndexByCount(count, offset, elements.size()));
    }

    private static int endIndexByCount(int count, int offset, int size) {
        if (count < 0) {
            return size;
        }
        if (offset + count > size) {
            return size;
        }
        return offset + count;
    }

    public static double getRealScoreForMinValue(String value, Collection<SortsetDatatypeOperations.ScoredByteBuffer> elements) {
        if (NEGATIVE_INFINITE.equals(value)) {
            return RangeUtils.findMinElement(elements);
        }
        if (POSITIVE_INFINITE.equals(value)) {
            return RangeUtils.findMaxElement(elements);
        }
        if (value.startsWith(EXCLUSIVE_SYMBOL)) {
            return RangeUtils.findMinExclusiveValue(value, elements);
        }
        return Double.parseDouble(value);
    }

    private static double findMinExclusiveValue(String value, Collection<SortsetDatatypeOperations.ScoredByteBuffer> elements) {
        double score = Double.parseDouble(value.substring(1, value.length()));
        SortsetDatatypeOperations.ScoredByteBuffer selectFirst = (SortsetDatatypeOperations.ScoredByteBuffer)Lambda.selectFirst(elements, (Matcher)Lambda.having((Object)((SortsetDatatypeOperations.ScoredByteBuffer)Lambda.on(SortsetDatatypeOperations.ScoredByteBuffer.class)).getScore(), (Matcher)Matchers.greaterThan((Comparable)Double.valueOf(score))));
        return selectFirst == null ? Double.POSITIVE_INFINITY : selectFirst.getScore();
    }

    public static double getRealScoreForMaxValue(String value, Collection<SortsetDatatypeOperations.ScoredByteBuffer> elements) {
        if (NEGATIVE_INFINITE.equals(value)) {
            return RangeUtils.findMinElement(elements);
        }
        if (POSITIVE_INFINITE.equals(value)) {
            return RangeUtils.findMaxElement(elements);
        }
        if (value.startsWith(EXCLUSIVE_SYMBOL)) {
            return RangeUtils.findMaxExclusiveValue(value, elements);
        }
        return Double.parseDouble(value);
    }

    private static double findMaxExclusiveValue(String value, Collection<SortsetDatatypeOperations.ScoredByteBuffer> elements) {
        double score = Double.parseDouble(value.substring(1, value.length()));
        List elementsWithLessScore = Lambda.select(elements, (Matcher)Lambda.having((Object)((SortsetDatatypeOperations.ScoredByteBuffer)Lambda.on(SortsetDatatypeOperations.ScoredByteBuffer.class)).getScore(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf(score))));
        return elementsWithLessScore.size() == 0 ? Double.NEGATIVE_INFINITY : ((SortsetDatatypeOperations.ScoredByteBuffer)elementsWithLessScore.get(elementsWithLessScore.size() - 1)).getScore();
    }

    private static double findMinElement(Collection<SortsetDatatypeOperations.ScoredByteBuffer> elements) {
        SortsetDatatypeOperations.ScoredByteBuffer selectMin = (SortsetDatatypeOperations.ScoredByteBuffer)Lambda.selectMin(elements, (Object)((SortsetDatatypeOperations.ScoredByteBuffer)Lambda.on(SortsetDatatypeOperations.ScoredByteBuffer.class)).getScore());
        return selectMin == null ? 0.0 : selectMin.getScore();
    }

    private static double findMaxElement(Collection<SortsetDatatypeOperations.ScoredByteBuffer> elements) {
        SortsetDatatypeOperations.ScoredByteBuffer selectMax = (SortsetDatatypeOperations.ScoredByteBuffer)Lambda.selectMax(elements, (Object)((SortsetDatatypeOperations.ScoredByteBuffer)Lambda.on(SortsetDatatypeOperations.ScoredByteBuffer.class)).getScore());
        return selectMax == null ? 0.0 : selectMax.getScore();
    }
}

