/*
 * Decompiled with CFR 0.152.
 */
package com.lynden.gmapsfx;

import com.lynden.gmapsfx.ClusteredGoogleMapView;
import com.lynden.gmapsfx.MapComponentInitializedListener;
import com.lynden.gmapsfx.javascript.event.UIEventType;
import com.lynden.gmapsfx.javascript.object.Animation;
import com.lynden.gmapsfx.javascript.object.ClusteredGoogleMap;
import com.lynden.gmapsfx.javascript.object.DirectionsPane;
import com.lynden.gmapsfx.javascript.object.InfoWindow;
import com.lynden.gmapsfx.javascript.object.InfoWindowOptions;
import com.lynden.gmapsfx.javascript.object.LatLong;
import com.lynden.gmapsfx.javascript.object.LatLongBounds;
import com.lynden.gmapsfx.javascript.object.MVCArray;
import com.lynden.gmapsfx.javascript.object.MapOptions;
import com.lynden.gmapsfx.javascript.object.MapTypeIdEnum;
import com.lynden.gmapsfx.javascript.object.Marker;
import com.lynden.gmapsfx.javascript.object.MarkerOptions;
import com.lynden.gmapsfx.service.directions.DirectionsRenderer;
import com.lynden.gmapsfx.shapes.ArcBuilder;
import com.lynden.gmapsfx.shapes.Circle;
import com.lynden.gmapsfx.shapes.CircleOptions;
import com.lynden.gmapsfx.shapes.Polygon;
import com.lynden.gmapsfx.shapes.PolygonOptions;
import com.lynden.gmapsfx.shapes.Polyline;
import com.lynden.gmapsfx.shapes.PolylineOptions;
import com.lynden.gmapsfx.shapes.Rectangle;
import com.lynden.gmapsfx.shapes.RectangleOptions;
import java.util.Locale;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import netscape.javascript.JSObject;

public class ClusteredMainApp
extends Application
implements MapComponentInitializedListener {
    protected ClusteredGoogleMapView mapComponent;
    protected ClusteredGoogleMap map;
    protected DirectionsPane directions;
    private Button btnZoomIn;
    private Button btnZoomOut;
    private Label lblZoom;
    private Label lblCenter;
    private Label lblClick;
    private ComboBox<MapTypeIdEnum> mapTypeCombo;
    private MarkerOptions markerOptions2;
    private Marker myMarker2;
    private Button btnHideMarker;
    private Button btnDeleteMarker;
    DirectionsRenderer renderer;

    public void start(Stage stage) throws Exception {
        this.mapComponent = new ClusteredGoogleMapView(null, Locale.getDefault().getLanguage(), null, true);
        this.mapComponent.addMapInializedListener(this);
        BorderPane bp = new BorderPane();
        ToolBar tb = new ToolBar();
        this.btnZoomIn = new Button("Zoom In");
        this.btnZoomIn.setOnAction(e -> this.map.zoomProperty().set(this.map.getZoom() + 1));
        this.btnZoomIn.setDisable(true);
        this.btnZoomOut = new Button("Zoom Out");
        this.btnZoomOut.setOnAction(e -> this.map.zoomProperty().set(this.map.getZoom() - 1));
        this.btnZoomOut.setDisable(true);
        this.lblZoom = new Label();
        this.lblCenter = new Label();
        this.lblClick = new Label();
        this.mapTypeCombo = new ComboBox();
        this.mapTypeCombo.setOnAction(e -> this.map.setMapType((MapTypeIdEnum)this.mapTypeCombo.getSelectionModel().getSelectedItem()));
        this.mapTypeCombo.setDisable(true);
        Button btnType = new Button("Map type");
        btnType.setOnAction(e -> this.map.setMapType(MapTypeIdEnum.HYBRID));
        this.btnHideMarker = new Button("Hide Marker");
        this.btnHideMarker.setOnAction(e -> this.hideMarker());
        this.btnDeleteMarker = new Button("Delete Marker");
        this.btnDeleteMarker.setOnAction(e -> this.deleteMarker());
        tb.getItems().addAll((Object[])new Node[]{this.btnZoomIn, this.btnZoomOut, this.mapTypeCombo, new Label("Zoom: "), this.lblZoom, new Label("Center: "), this.lblCenter, new Label("Click: "), this.lblClick, this.btnHideMarker, this.btnDeleteMarker});
        bp.setTop((Node)tb);
        bp.setCenter((Node)this.mapComponent);
        Scene scene = new Scene((Parent)bp);
        stage.setScene(scene);
        stage.show();
    }

    @Override
    public void mapInitialized() {
        LatLong center = new LatLong(47.606189, -122.335842);
        this.mapComponent.addMapReadyListener(() -> this.checkCenter(center));
        MapOptions options = new MapOptions();
        options.center(center).mapMarker(true).zoom(9.0).overviewMapControl(false).panControl(false).rotateControl(false).scaleControl(false).streetViewControl(false).zoomControl(false).mapType(MapTypeIdEnum.TERRAIN).styleString("[{'featureType':'landscape','stylers':[{'saturation':-100},{'lightness':65},{'visibility':'on'}]},{'featureType':'poi','stylers':[{'saturation':-100},{'lightness':51},{'visibility':'simplified'}]},{'featureType':'road.highway','stylers':[{'saturation':-100},{'visibility':'simplified'}]},{\"featureType\":\"road.arterial\",\"stylers\":[{\"saturation\":-100},{\"lightness\":30},{\"visibility\":\"on\"}]},{\"featureType\":\"road.local\",\"stylers\":[{\"saturation\":-100},{\"lightness\":40},{\"visibility\":\"on\"}]},{\"featureType\":\"transit\",\"stylers\":[{\"saturation\":-100},{\"visibility\":\"simplified\"}]},{\"featureType\":\"administrative.province\",\"stylers\":[{\"visibility\":\"off\"}]},{\"featureType\":\"water\",\"elementType\":\"labels\",\"stylers\":[{\"visibility\":\"on\"},{\"lightness\":-25},{\"saturation\":-100}]},{\"featureType\":\"water\",\"elementType\":\"geometry\",\"stylers\":[{\"hue\":\"#ffff00\"},{\"lightness\":-25},{\"saturation\":-97}]}]");
        this.map = this.mapComponent.createMap(options, false);
        this.directions = this.mapComponent.getDirec();
        this.map.setHeading(123.2);
        MarkerOptions markerOptions = new MarkerOptions();
        LatLong markerLatLong = new LatLong(47.606189, -122.335842);
        markerOptions.position(markerLatLong).title("My new Marker").icon("mymarker.png").animation(Animation.DROP).visible(true);
        Marker myMarker = new Marker(markerOptions);
        this.markerOptions2 = new MarkerOptions();
        LatLong markerLatLong2 = new LatLong(47.906189, -122.335842);
        this.markerOptions2.position(markerLatLong2).title("My new Marker").visible(true);
        this.myMarker2 = new Marker(this.markerOptions2);
        this.map.addClusterableMarker(myMarker);
        this.map.addClusterableMarker(this.myMarker2);
        InfoWindowOptions infoOptions = new InfoWindowOptions();
        infoOptions.content("<h2>Here's an info window</h2><h3>with some info</h3>").position(center);
        InfoWindow window = new InfoWindow(infoOptions);
        window.open(this.map, myMarker);
        this.map.fitBounds(new LatLongBounds(new LatLong(30.0, 120.0), center));
        this.lblCenter.setText(this.map.getCenter().toString());
        this.map.centerProperty().addListener((obs, o, n) -> this.lblCenter.setText(n.toString()));
        this.lblZoom.setText(Integer.toString(this.map.getZoom()));
        this.map.zoomProperty().addListener((obs, o, n) -> this.lblZoom.setText(n.toString()));
        this.map.addUIEventHandler(UIEventType.click, obj -> {
            LatLong ll = new LatLong((JSObject)obj.getMember("latLng"));
            this.lblClick.setText(ll.toString());
        });
        this.btnZoomIn.setDisable(false);
        this.btnZoomOut.setDisable(false);
        this.mapTypeCombo.setDisable(false);
        this.mapTypeCombo.getItems().addAll((Object[])MapTypeIdEnum.ALL);
        Object[] ary = new LatLong[]{markerLatLong, markerLatLong2};
        MVCArray mvc = new MVCArray(ary);
        PolylineOptions polyOpts = (PolylineOptions)((PolylineOptions)new PolylineOptions().path(mvc).strokeColor("red")).strokeWeight(2.0);
        Polyline poly = new Polyline(polyOpts);
        this.map.addMapShape(poly);
        this.map.addUIEventHandler(poly, UIEventType.click, obj -> {
            LatLong ll = new LatLong((JSObject)obj.getMember("latLng"));
        });
        LatLong poly1 = new LatLong(47.429945, -122.84363);
        LatLong poly2 = new LatLong(47.361153, -123.0304);
        LatLong poly3 = new LatLong(47.387193, -123.11554);
        LatLong poly4 = new LatLong(47.585789, -122.96722);
        Object[] pAry = new LatLong[]{poly1, poly2, poly3, poly4};
        MVCArray pmvc = new MVCArray(pAry);
        PolygonOptions polygOpts = (PolygonOptions)((PolygonOptions)((PolygonOptions)((PolygonOptions)((PolygonOptions)new PolygonOptions().paths(pmvc).strokeColor("blue")).strokeWeight(2.0)).editable(false)).fillColor("lightBlue")).fillOpacity(0.5);
        Polygon pg = new Polygon(polygOpts);
        this.map.addMapShape(pg);
        this.map.addUIEventHandler(pg, UIEventType.click, obj -> pg.setEditable(!pg.getEditable()));
        LatLong centreC = new LatLong(47.545481, -121.87384);
        CircleOptions cOpts = (CircleOptions)((CircleOptions)((CircleOptions)((CircleOptions)new CircleOptions().center(centreC).radius(5000.0).strokeColor("green")).strokeWeight(2.0)).fillColor("orange")).fillOpacity(0.3);
        Circle c = new Circle(cOpts);
        this.map.addMapShape(c);
        this.map.addUIEventHandler(c, UIEventType.click, obj -> c.setEditable(!c.getEditable()));
        LatLongBounds llb = new LatLongBounds(new LatLong(47.533893, -122.89856), new LatLong(47.580694, -122.80312));
        RectangleOptions rOpts = (RectangleOptions)((RectangleOptions)((RectangleOptions)new RectangleOptions().bounds(llb).strokeColor("black")).strokeWeight(2.0)).fillColor("null");
        Rectangle rt = new Rectangle(rOpts);
        this.map.addMapShape(rt);
        LatLong arcC = new LatLong(47.227029, -121.81641);
        double startBearing = 0.0;
        double endBearing = 30.0;
        double radius = 30000.0;
        MVCArray path = ArcBuilder.buildArcPoints(arcC, startBearing, endBearing, radius);
        path.push(arcC);
        Polygon arc = new Polygon((PolygonOptions)((PolygonOptions)((PolygonOptions)((PolygonOptions)((PolygonOptions)new PolygonOptions().paths(path).strokeColor("blue")).fillColor("lightBlue")).fillOpacity(0.3)).strokeWeight(2.0)).editable(false));
        this.map.addMapShape(arc);
        this.map.addUIEventHandler(arc, UIEventType.click, obj -> arc.setEditable(!arc.getEditable()));
    }

    private void hideMarker() {
        boolean visible = this.myMarker2.getVisible();
        this.myMarker2.setVisible(!visible);
    }

    private void deleteMarker() {
        this.map.removeMarker(this.myMarker2);
    }

    private void checkCenter(LatLong center) {
    }

    public static void main(String[] args) {
        System.setProperty("java.net.useSystemProxies", "true");
        ClusteredMainApp.launch((String[])args);
    }
}

