/*
 * Decompiled with CFR 0.152.
 */
package com.lynden.gmapsfx.javascript.event;

import com.lynden.gmapsfx.javascript.event.GFXEventHandler;
import com.lynden.gmapsfx.javascript.event.GMapMouseEvent;
import com.lynden.gmapsfx.javascript.event.MouseEventHandler;
import com.lynden.gmapsfx.javascript.event.StateEventHandler;
import com.lynden.gmapsfx.javascript.event.UIEventHandler;
import com.lynden.gmapsfx.javascript.object.LatLong;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import netscape.javascript.JSObject;

public class EventHandlers {
    private final Map<String, GFXEventHandler> handlers = new HashMap<String, GFXEventHandler>();

    public String registerHandler(GFXEventHandler handler) {
        String uuid = UUID.randomUUID().toString();
        this.handlers.put(uuid, handler);
        return uuid;
    }

    public void handleUIEvent(String callbackKey, JSObject result) {
        if (this.handlers.containsKey(callbackKey) && this.handlers.get(callbackKey) instanceof UIEventHandler) {
            ((UIEventHandler)this.handlers.get(callbackKey)).handle(result);
        } else if (this.handlers.containsKey(callbackKey) && this.handlers.get(callbackKey) instanceof MouseEventHandler) {
            ((MouseEventHandler)this.handlers.get(callbackKey)).handle(this.buildMouseEvent(result));
        } else {
            System.err.println("Error in handle: " + callbackKey + " for result: " + result);
        }
    }

    public void handleStateEvent(String callbackKey) {
        if (this.handlers.containsKey(callbackKey) && this.handlers.get(callbackKey) instanceof StateEventHandler) {
            ((StateEventHandler)this.handlers.get(callbackKey)).handle();
        } else {
            System.err.println("Error in handle: " + callbackKey + " for state handler ");
        }
    }

    protected GMapMouseEvent buildMouseEvent(JSObject jsObject) {
        LatLong latLong = new LatLong((JSObject)jsObject.getMember("latLng"));
        return new GMapMouseEvent(latLong);
    }
}

