/*
 * Decompiled with CFR 0.152.
 */
package com.lynden.gmapsfx.service.directions;

import com.lynden.gmapsfx.javascript.JavascriptObject;
import com.lynden.gmapsfx.javascript.object.LatLong;
import com.lynden.gmapsfx.service.directions.DirectionsSteps;
import com.lynden.gmapsfx.service.directions.Distance;
import com.lynden.gmapsfx.service.directions.Duration;
import com.lynden.gmapsfx.service.geocoding.GeocoderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import netscape.javascript.JSObject;

public class DirectionsLeg
extends JavascriptObject {
    public DirectionsLeg() {
        super("google.maps.DirectionsLeg");
    }

    public DirectionsLeg(JSObject jsObject) {
        super("google.maps.DirectionsLeg", jsObject);
    }

    public List<DirectionsSteps> getSteps() {
        ArrayList<DirectionsSteps> result = new ArrayList<DirectionsSteps>();
        List<JSObject> jsLocalities = GeocoderUtils.getJSObjectsFromArray((JSObject)this.getJSObject().getMember("steps"));
        for (JSObject jsLocality : jsLocalities) {
            DirectionsSteps ll = new DirectionsSteps(jsLocality);
            if (jsLocality.toString().equals("undefined")) continue;
            result.add(ll);
        }
        return result;
    }

    public Distance getDistance() {
        try {
            JSObject distance = (JSObject)this.getJSObject().getMember("distance");
            return new Distance(distance);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public Duration getDuration() {
        try {
            JSObject duration = (JSObject)this.getJSObject().getMember("duration");
            return new Duration(duration);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public LatLong getStartLocation() {
        try {
            JSObject location = (JSObject)this.getJSObject().getMember("start_location");
            return new LatLong(location);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public LatLong getEndLocation() {
        try {
            JSObject location = (JSObject)this.getJSObject().getMember("end_location");
            return new LatLong(location);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public String getStartAddress() {
        try {
            JSObject location = (JSObject)this.getJSObject().getMember("start_address");
            return location.toString();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public String getEndAddress() {
        try {
            JSObject location = (JSObject)this.getJSObject().getMember("end_address");
            return location.toString();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public String toString() {
        return "Distancia: " + this.getDistance().getValue() + "\nDuracao: " + this.getDuration().getValue() + "\nInicio: " + this.getStartAddress() + "\nFim: " + this.getEndAddress();
    }
}

