/*
 * Decompiled with CFR 0.152.
 */
package com.lynden.gmapsfx.service.directions;

import com.lynden.gmapsfx.javascript.JavascriptObject;
import com.lynden.gmapsfx.javascript.object.LatLong;
import com.lynden.gmapsfx.javascript.object.LatLongBounds;
import com.lynden.gmapsfx.service.directions.DirectionsLeg;
import com.lynden.gmapsfx.service.geocoding.GeocoderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import netscape.javascript.JSObject;

public class DirectionsRoute
extends JavascriptObject {
    public DirectionsRoute() {
        super("google.maps.DirectionsRoute");
    }

    public DirectionsRoute(JSObject jsObject) {
        super("google.maps.DirectionsRoute", jsObject);
    }

    public List<DirectionsLeg> getLegs() {
        ArrayList<DirectionsLeg> result = new ArrayList<DirectionsLeg>();
        List<JSObject> jsLocalities = GeocoderUtils.getJSObjectsFromArray((JSObject)this.getJSObject().getMember("legs"));
        for (JSObject jsLocality : jsLocalities) {
            DirectionsLeg ll = new DirectionsLeg(jsLocality);
            if (jsLocality.toString().equals("undefined")) continue;
            result.add(ll);
        }
        return result;
    }

    public String getWaypointOrder() {
        return this.getJSObject().getMember("waypoint_order").toString();
    }

    public List<LatLong> getOverviewPath() {
        ArrayList<LatLong> result = new ArrayList<LatLong>();
        List<JSObject> jsLocalities = GeocoderUtils.getJSObjectsFromArray((JSObject)this.getJSObject().getMember("overview_path"));
        for (JSObject jsLocality : jsLocalities) {
            LatLong ll = new LatLong(jsLocality);
            if (jsLocality.toString().equals("undefined")) continue;
            result.add(ll);
        }
        return result;
    }

    public LatLongBounds getBounds() {
        try {
            JSObject bounds = (JSObject)this.getJSObject().getMember("bounds");
            return new LatLongBounds(bounds);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }
}

