/*
 * Decompiled with CFR 0.152.
 */
package com.lynden.gmapsfx.service.geocoding;

import com.lynden.gmapsfx.javascript.JavascriptObject;
import com.lynden.gmapsfx.javascript.object.LatLong;
import com.lynden.gmapsfx.javascript.object.LatLongBounds;
import com.lynden.gmapsfx.service.geocoding.GeocoderComponentRestrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeocoderRequest
extends JavascriptObject {
    private static final Logger LOG = LoggerFactory.getLogger(GeocoderRequest.class);

    public GeocoderRequest(String address) {
        this(address, null, null, null, null, null);
    }

    public GeocoderRequest(String address, LatLong latLong, String placeId, LatLongBounds bounds, GeocoderComponentRestrictions restrictions, String region) {
        super("google.maps.GeocoderRequest", GeocoderRequest.convertToJavascriptString(address, latLong, placeId, bounds, restrictions, region));
    }

    private static String convertToJavascriptString(String address, LatLong location, String placeId, LatLongBounds bounds, GeocoderComponentRestrictions restrictions, String region) {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        boolean something = false;
        if (address != null) {
            something = true;
            builder.append("address: '").append(address).append("'");
        }
        if (restrictions != null) {
            builder.append(something ? "," : "");
            builder.append("componentRestrictions: ").append(restrictions.getVariableName());
            something = true;
        }
        if (location != null) {
            builder.append(something ? "," : "");
            builder.append("location: ").append(location.getVariableName());
            something = true;
        }
        if (placeId != null) {
            builder.append(something ? "," : "");
            something = true;
            builder.append("placeId: '").append(placeId).append("'");
        }
        if (bounds != null) {
            builder.append(something ? "," : "");
            builder.append("bounds: ").append(bounds.getVariableName());
            something = true;
        }
        if (region != null) {
            builder.append(something ? "," : "");
            something = true;
            builder.append("region: '").append(region).append("'");
        }
        builder.append("}");
        LOG.trace("REQUEST " + builder.toString());
        return builder.toString();
    }

    public String getAddress() {
        return this.invokeJavascriptReturnValue("address", String.class);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("address: '").append(this.getAddress()).append("'");
        return builder.toString();
    }
}

