/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AppThread;
import com.machinepublishers.jbrowserdriver.Context;
import com.machinepublishers.jbrowserdriver.CookieStore;
import com.machinepublishers.jbrowserdriver.ElementServer;
import com.machinepublishers.jbrowserdriver.JBrowserDriverRemote;
import com.machinepublishers.jbrowserdriver.KeyboardServer;
import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.MouseServer;
import com.machinepublishers.jbrowserdriver.NavigationServer;
import com.machinepublishers.jbrowserdriver.OptionsServer;
import com.machinepublishers.jbrowserdriver.PortGroup;
import com.machinepublishers.jbrowserdriver.RemoteObject;
import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.SocketFactory;
import com.machinepublishers.jbrowserdriver.SocketLock;
import com.machinepublishers.jbrowserdriver.StatusCode;
import com.machinepublishers.jbrowserdriver.StatusMonitor;
import com.machinepublishers.jbrowserdriver.StreamConnection;
import com.machinepublishers.jbrowserdriver.StreamHandler;
import com.machinepublishers.jbrowserdriver.TargetLocatorServer;
import com.machinepublishers.jbrowserdriver.Util;
import com.sun.javafx.webkit.Accessor;
import com.sun.webkit.WebPage;
import com.sun.webkit.network.CookieManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.CookieHandler;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.web.WebEngine;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.Killable;

class JBrowserDriverServer
extends RemoteObject
implements JBrowserDriverRemote,
WebDriver,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByName,
FindsByCssSelector,
FindsByTagName,
FindsByXPath,
HasInputDevices,
HasCapabilities,
TakesScreenshot,
Killable {
    private static final AtomicInteger childPort = new AtomicInteger();
    private static final AtomicReference<SocketFactory> socketFactory = new AtomicReference();
    private static Registry registry;
    final AtomicReference<Context> context = new AtomicReference();

    public static void main(String[] args) {
        try {
            CookieManager.setDefault((CookieHandler)new CookieStore());
            try {
                URL.setURLStreamHandlerFactory(new StreamHandler());
            }
            catch (Throwable t) {
                Field factory = null;
                try {
                    factory = URL.class.getDeclaredField("factory");
                    factory.setAccessible(true);
                    Object curFac = factory.get(null);
                    Field chainedFactory = curFac.getClass().getDeclaredField("chainFac");
                    chainedFactory.setAccessible(true);
                    chainedFactory.set(curFac, new StreamHandler());
                }
                catch (Throwable t2) {
                    factory.set(null, new StreamHandler());
                }
            }
            String host = System.getProperty("java.rmi.server.hostname");
            childPort.set((int)Long.parseLong(args[0]));
            long parentPort = Long.parseLong(args[1]);
            parentPort = parentPort < 0L ? 0L : parentPort;
            long parentAltPort = Long.parseLong(args[2]);
            parentAltPort = parentAltPort < 0L ? 0L : parentAltPort;
            Registry registryTmp = null;
            int maxTries = 5;
            for (int i = 1; i <= 5; ++i) {
                try {
                    if (childPort.get() <= 0) {
                        childPort.set(JBrowserDriverServer.findPort(host));
                    }
                    socketFactory.set(new SocketFactory(host, new PortGroup(childPort.get(), parentPort, parentAltPort), new HashSet<SocketLock>()));
                    registryTmp = LocateRegistry.createRegistry(childPort.get(), socketFactory.get(), socketFactory.get());
                    break;
                }
                catch (Throwable t) {
                    if (i != 5) continue;
                    Util.handleException(t);
                    continue;
                }
            }
            registry = registryTmp;
            registry.rebind("JBrowserDriverRemote", new JBrowserDriverServer());
            RMISocketFactory.setSocketFactory(socketFactory.get());
            System.out.println("ready on ports " + childPort.get() + "/" + parentPort + "/" + parentAltPort);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private static int findPort(String host) throws IOException {
        ServerSocket socket = null;
        try {
            socket = new ServerSocket();
            socket.setReuseAddress(true);
            socket.bind(new InetSocketAddress(host, 0));
            int n = socket.getLocalPort();
            return n;
        }
        finally {
            Util.close(socket);
        }
    }

    static int childPort() {
        return childPort.get();
    }

    static SocketFactory socketFactory() {
        return socketFactory.get();
    }

    @Override
    public void setUp(Settings settings) {
        SettingsManager.register(settings);
        this.context.set(new Context());
    }

    @Override
    public void storeCapabilities(Capabilities capabilities) {
        this.context.get().capabilities.set(capabilities);
    }

    @Override
    public void init() {
        this.context.get().init(this);
    }

    @Override
    public void reset(Settings settings) {
        AppThread.exec(new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                JBrowserDriverServer.this.context.get().item().engine.get().getLoadWorker().cancel();
                return null;
            }
        });
        Accessor.getPageFor((WebEngine)this.context.get().item().engine.get()).stop();
        ((CookieStore)CookieManager.getDefault()).clear();
        StatusMonitor.instance().clear();
        LogsServer.instance().clear(null);
        SettingsManager.register(settings);
        this.context.get().reset(this);
    }

    @Override
    public void reset() {
        this.reset(SettingsManager.settings());
    }

    @Override
    public String getPageSource() {
        String outerHtml;
        this.init();
        ElementServer element = ElementServer.create(this.context.get().item()).findElementByTagName("html");
        if (element != null && (outerHtml = element.getAttribute("outerHTML")) != null && !outerHtml.isEmpty()) {
            return outerHtml;
        }
        WebPage page = Accessor.getPageFor((WebEngine)this.context.get().item().engine.get());
        String html = page.getHtml(page.getMainFrame());
        if (html != null && !html.isEmpty()) {
            return html;
        }
        return page.getInnerText(page.getMainFrame());
    }

    @Override
    public String getCurrentUrl() {
        this.init();
        return AppThread.exec(this.context.get().item().statusCode, new AppThread.Sync<String>(){

            @Override
            public String perform() {
                return JBrowserDriverServer.this.context.get().item().view.get().getEngine().getLocation();
            }
        });
    }

    @Override
    public void pageWait() {
        this.context.get().item().httpListener.get().resetStatusCode();
        this.getStatusCode();
    }

    @Override
    public int getStatusCode() {
        return this.getStatusCode(this.context.get().timeouts.get().getPageLoadTimeoutMS());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getStatusCode(long waitMS) {
        int statusCode;
        this.init();
        StatusCode statusCode2 = this.context.get().item().statusCode;
        synchronized (statusCode2) {
            long start = System.currentTimeMillis();
            while ((statusCode = this.context.get().item().statusCode.get()) <= 0) {
                try {
                    long nextWait = waitMS - (System.currentTimeMillis() - start);
                    if (nextWait >= 0L) {
                        this.context.get().item().statusCode.wait(nextWait);
                        continue;
                    }
                    if (waitMS != 0L) break;
                    this.context.get().item().statusCode.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return statusCode;
    }

    @Override
    public String getTitle() {
        this.init();
        return AppThread.exec(this.context.get().item().statusCode, new AppThread.Sync<String>(){

            @Override
            public String perform() {
                return JBrowserDriverServer.this.context.get().item().view.get().getEngine().getTitle();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void get(final String url) {
        this.init();
        long start = System.currentTimeMillis();
        try {
            AppThread.exec(this.context.get().item().statusCode, this.context.get().timeouts.get().getPageLoadTimeoutMS(), new AppThread.Sync<Object>(){

                @Override
                public Object perform() {
                    JBrowserDriverServer.this.context.get().item().httpListener.get().resetStatusCode();
                    JBrowserDriverServer.this.context.get().item().engine.get().load(url);
                    return null;
                }
            });
            long end = System.currentTimeMillis();
            if (this.context.get().timeouts.get().getPageLoadTimeoutMS() == 0L) {
                this.getStatusCode();
            } else {
                long waitMS = this.context.get().timeouts.get().getPageLoadTimeoutMS() - (end - start);
                if (waitMS > 0L) {
                    this.getStatusCode(waitMS);
                }
            }
            if (this.context.get().item().statusCode.get() != 0) return;
        }
        catch (Throwable throwable) {
            if (this.context.get().item().statusCode.get() != 0) throw throwable;
            AppThread.exec(new AppThread.Sync<Object>(){

                @Override
                public Object perform() {
                    JBrowserDriverServer.this.context.get().item().engine.get().getLoadWorker().cancel();
                    throw new TimeoutException("Timeout of " + JBrowserDriverServer.this.context.get().timeouts.get().getPageLoadTimeoutMS() + "ms reached.");
                }
            });
            throw throwable;
        }
        AppThread.exec(new /* invalid duplicate definition of identical inner class */);
    }

    @Override
    public ElementServer findElement(By by) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElement(by);
    }

    public List findElements(By by) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElements(by);
    }

    @Override
    public ElementServer findElementById(String id) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementById(id);
    }

    public List findElementsById(String id) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementsById(id);
    }

    @Override
    public ElementServer findElementByXPath(String expr) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementByXPath(expr);
    }

    public List findElementsByXPath(String expr) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementsByXPath(expr);
    }

    @Override
    public ElementServer findElementByLinkText(String text) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementByLinkText(text);
    }

    @Override
    public ElementServer findElementByPartialLinkText(String text) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementByPartialLinkText(text);
    }

    public List findElementsByLinkText(String text) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementsByLinkText(text);
    }

    public List findElementsByPartialLinkText(String text) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementsByPartialLinkText(text);
    }

    @Override
    public ElementServer findElementByClassName(String cssClass) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementByClassName(cssClass);
    }

    public List findElementsByClassName(String cssClass) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementsByClassName(cssClass);
    }

    @Override
    public ElementServer findElementByName(String name) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementByName(name);
    }

    public List findElementsByName(String name) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementsByName(name);
    }

    @Override
    public ElementServer findElementByCssSelector(String expr) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementByCssSelector(expr);
    }

    public List findElementsByCssSelector(String expr) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementsByCssSelector(expr);
    }

    @Override
    public ElementServer findElementByTagName(String tagName) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementByTagName(tagName);
    }

    public List findElementsByTagName(String tagName) {
        this.init();
        return ElementServer.create(this.context.get().item()).findElementsByTagName(tagName);
    }

    @Override
    public Object executeAsyncScript(String script, Object ... args) {
        this.init();
        return ElementServer.create(this.context.get().item()).executeAsyncScript(script, args);
    }

    @Override
    public Object executeScript(String script, Object ... args) {
        this.init();
        return ElementServer.create(this.context.get().item()).executeScript(script, args);
    }

    @Override
    public KeyboardServer getKeyboard() {
        this.init();
        return this.context.get().keyboard.get();
    }

    @Override
    public MouseServer getMouse() {
        this.init();
        return this.context.get().mouse.get();
    }

    @Override
    public Capabilities getCapabilities() {
        this.init();
        return this.context.get().capabilities.get();
    }

    @Override
    public void close() {
        this.init();
        this.context.get().removeItem();
    }

    @Override
    public String getWindowHandle() {
        this.init();
        return this.context.get().itemId();
    }

    @Override
    public Set<String> getWindowHandles() {
        this.init();
        return this.context.get().itemIds();
    }

    @Override
    public OptionsServer manage() {
        this.init();
        return this.context.get().options.get();
    }

    @Override
    public LogsServer logs() {
        return LogsServer.instance();
    }

    @Override
    public NavigationServer navigate() {
        this.init();
        return this.context.get().navigation.get();
    }

    @Override
    public void quit() {
        this.getStatusCode();
    }

    @Override
    public TargetLocatorServer switchTo() {
        this.init();
        return this.context.get().targetLocator.get();
    }

    @Override
    public void kill() {
    }

    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        return (X)outputType.convertFromPngBytes(this.getScreenshot());
    }

    @Override
    public byte[] getScreenshot() throws WebDriverException {
        this.init();
        return this.context.get().robot.get().screenshot();
    }

    @Override
    public File cacheDir() {
        return StreamConnection.cacheDir();
    }

    @Override
    public File attachmentsDir() {
        return StreamConnection.attachmentsDir();
    }

    @Override
    public File mediaDir() {
        return StreamConnection.mediaDir();
    }
}

