/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mangofactory.swagger.models.dto.jackson.SwaggerJacksonProvider;
import com.mangofactory.swagger.models.property.provider.DefaultModelPropertiesProvider;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class JacksonSwaggerSupport
implements ApplicationContextAware {
    private ObjectMapper springsMessageConverterObjectMapper;
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    private ApplicationContext applicationContext;

    public ObjectMapper getSpringsMessageConverterObjectMapper() {
        return this.springsMessageConverterObjectMapper;
    }

    @Autowired
    public void setRequestMappingHandlerAdapter(RequestMappingHandlerAdapter[] requestMappingHandlerAdapters) {
        if (requestMappingHandlerAdapters.length > 1) {
            for (RequestMappingHandlerAdapter adapter : requestMappingHandlerAdapters) {
                if (!adapter.getClass().getCanonicalName().equals(RequestMappingHandlerAdapter.class.getCanonicalName())) continue;
                this.requestMappingHandlerAdapter = adapter;
            }
        } else {
            this.requestMappingHandlerAdapter = requestMappingHandlerAdapters[0];
        }
    }

    @PostConstruct
    public void setup() {
        List messageConverters = this.requestMappingHandlerAdapter.getMessageConverters();
        for (HttpMessageConverter messageConverter : messageConverters) {
            if (!(messageConverter instanceof MappingJackson2HttpMessageConverter)) continue;
            MappingJackson2HttpMessageConverter m = (MappingJackson2HttpMessageConverter)messageConverter;
            this.springsMessageConverterObjectMapper = m.getObjectMapper();
            SwaggerJacksonProvider swaggerJacksonProvider = new SwaggerJacksonProvider();
            this.springsMessageConverterObjectMapper.registerModule(swaggerJacksonProvider.swaggerJacksonModule());
        }
        Map beans = this.applicationContext.getBeansOfType(DefaultModelPropertiesProvider.class);
        for (DefaultModelPropertiesProvider defaultModelPropertiesProvider : beans.values()) {
            defaultModelPropertiesProvider.setObjectMapper(this.springsMessageConverterObjectMapper);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

