/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation;

import com.google.common.collect.Lists;
import com.mangofactory.swagger.authorization.AuthorizationContext;
import com.mangofactory.swagger.models.dto.Authorization;
import com.mangofactory.swagger.models.dto.AuthorizationScope;
import com.mangofactory.swagger.models.dto.builder.AuthorizationBuilder;
import com.mangofactory.swagger.models.dto.builder.AuthorizationScopeBuilder;
import com.mangofactory.swagger.readers.operation.RequestMappingReader;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;

public class OperationAuthReader
implements RequestMappingReader {
    private static final Logger LOG = LoggerFactory.getLogger(OperationAuthReader.class);

    @Override
    public void execute(RequestMappingContext context) {
        com.wordnik.swagger.annotations.Authorization[] authorizationAnnotations;
        ApiOperation apiOperationAnnotation;
        AuthorizationContext authorizationContext = (AuthorizationContext)context.get("authorizationContext");
        HandlerMethod handlerMethod = context.getHandlerMethod();
        String requestMappingPattern = (String)context.get("requestMappingPattern");
        List<Object> authorizations = Lists.newArrayList();
        if (null != authorizationContext) {
            authorizations = authorizationContext.getAuthorizationsForPath(requestMappingPattern);
        }
        if (null != (apiOperationAnnotation = (ApiOperation)handlerMethod.getMethodAnnotation(ApiOperation.class)) && null != apiOperationAnnotation.authorizations() && (authorizationAnnotations = apiOperationAnnotation.authorizations()) != null && authorizationAnnotations.length > 0 && StringUtils.hasText((String)authorizationAnnotations[0].value())) {
            authorizations = Lists.newArrayList();
            for (com.wordnik.swagger.annotations.Authorization authorization : authorizationAnnotations) {
                String value = authorization.value();
                com.wordnik.swagger.annotations.AuthorizationScope[] scopes = authorization.scopes();
                ArrayList authorizationScopeList = Lists.newArrayList();
                for (com.wordnik.swagger.annotations.AuthorizationScope authorizationScope : scopes) {
                    String description = authorizationScope.description();
                    String scope = authorizationScope.scope();
                    authorizationScopeList.add(new AuthorizationScopeBuilder().scope(scope).description(description).build());
                }
                AuthorizationScope[] authorizationScopes = authorizationScopeList.toArray(new AuthorizationScope[authorizationScopeList.size()]);
                Authorization authorizationModel = new AuthorizationBuilder().type(value).scopes(authorizationScopes).build();
                authorizations.add(authorizationModel);
            }
        }
        LOG.info("Authorization count {} for method {}", (Object)handlerMethod.getMethod().getName(), (Object)authorizations.size());
        context.put("authorizations", authorizations);
    }
}

