/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation.parameter;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.mangofactory.swagger.models.Enums;
import com.mangofactory.swagger.models.dto.AllowableListValues;
import com.mangofactory.swagger.models.dto.AllowableRangeValues;
import com.mangofactory.swagger.models.dto.AllowableValues;
import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiParam;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.util.StringUtils;

public class ParameterAllowableReader
implements Command<RequestMappingContext> {
    private static final Logger log = LoggerFactory.getLogger(ParameterAllowableReader.class);

    @Override
    public void execute(RequestMappingContext context) {
        MethodParameter methodParameter = (MethodParameter)context.get("methodParameter");
        AllowableValues allowableValues = null;
        String allowableValueString = this.findAnnotatedAllowableValues(methodParameter);
        if (allowableValueString != null && !"".equals(allowableValueString)) {
            allowableValues = ParameterAllowableReader.allowableValueFromString(allowableValueString);
        } else {
            if (methodParameter.getParameterType().isEnum()) {
                allowableValues = Enums.allowableValues((Class)methodParameter.getParameterType());
            }
            if (methodParameter.getParameterType().isArray()) {
                allowableValues = Enums.allowableValues(methodParameter.getParameterType().getComponentType());
            }
        }
        context.put("allowableValues", allowableValues);
    }

    public static AllowableValues allowableValueFromString(String allowableValueString) {
        AllowableListValues allowableValues = null;
        if ((allowableValueString = allowableValueString.trim().replaceAll(" ", "")).startsWith("range[")) {
            allowableValueString = allowableValueString.replaceAll("range\\[", "").replaceAll("]", "");
            Iterable split = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)allowableValueString);
            ArrayList ranges = Lists.newArrayList((Iterable)split);
            allowableValues = new AllowableRangeValues((String)ranges.get(0), (String)ranges.get(1));
        } else if (allowableValueString.contains(",")) {
            Iterable split = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)allowableValueString);
            allowableValues = new AllowableListValues((List)Lists.newArrayList((Iterable)split), "LIST");
        } else if (StringUtils.hasText((String)allowableValueString)) {
            List<String> singleVal = Arrays.asList(allowableValueString.trim());
            allowableValues = new AllowableListValues(singleVal, "LIST");
        }
        return allowableValues;
    }

    private String findAnnotatedAllowableValues(MethodParameter methodParameter) {
        Annotation[] methodAnnotations = methodParameter.getParameterAnnotations();
        if (null != methodAnnotations) {
            for (Annotation annotation : methodAnnotations) {
                if (!(annotation instanceof ApiParam)) continue;
                return ((ApiParam)annotation).allowableValues();
            }
        }
        return null;
    }
}

