/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.readers.operation.parameter;

import com.mangofactory.swagger.readers.Command;
import com.mangofactory.swagger.scanners.RequestMappingContext;
import com.wordnik.swagger.annotations.ApiParam;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

public class ParameterRequiredReader
implements Command<RequestMappingContext> {
    @Override
    public void execute(RequestMappingContext context) {
        MethodParameter methodParameter = (MethodParameter)context.get("methodParameter");
        context.put("required", this.getAnnotatedRequired(methodParameter));
    }

    private Boolean getAnnotatedRequired(MethodParameter methodParameter) {
        HashSet<Boolean> requiredSet = new HashSet<Boolean>();
        Annotation[] methodAnnotations = methodParameter.getParameterAnnotations();
        boolean optional = this.isOptional(methodParameter);
        if (null != methodAnnotations) {
            for (Annotation annotation : methodAnnotations) {
                if (annotation instanceof ApiParam) {
                    requiredSet.add(((ApiParam)annotation).required());
                    continue;
                }
                if (annotation instanceof RequestParam) {
                    requiredSet.add(!optional && ((RequestParam)annotation).required());
                    continue;
                }
                if (annotation instanceof RequestHeader) {
                    requiredSet.add(!optional && ((RequestHeader)annotation).required());
                    continue;
                }
                if (!(annotation instanceof PathVariable)) continue;
                requiredSet.add(true);
            }
        }
        return requiredSet.contains(true);
    }

    private boolean isOptional(MethodParameter methodParameter) {
        return methodParameter.getParameterType().getName().equals("java.util.Optional");
    }
}

