/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.plugins.gradle.api;

import java.util.function.Consumer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public final class GradleApiLog {
    private final int loggingLevel;
    private final Log delegate;

    GradleApiLog(int loggingLevel) {
        this.loggingLevel = loggingLevel;
        this.delegate = new SystemStreamLog();
    }

    public void debug(CharSequence content) {
        this.log(0, arg_0 -> ((Log)this.delegate).debug(arg_0), content);
    }

    public void info(CharSequence content) {
        this.log(1, arg_0 -> ((Log)this.delegate).info(arg_0), content);
    }

    public void warn(CharSequence content) {
        this.log(2, arg_0 -> ((Log)this.delegate).warn(arg_0), content);
    }

    public void error(CharSequence content) {
        this.log(3, arg_0 -> ((Log)this.delegate).error(arg_0), content);
    }

    private void log(int level, Consumer<CharSequence> logFunc, CharSequence content) {
        if (this.loggingLevel <= level) {
            logFunc.accept(content);
        }
    }
}

