/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.yakc.api.batch.v1;

import com.marcnuri.yakc.api.Api;
import com.marcnuri.yakc.api.KubernetesCall;
import com.marcnuri.yakc.api.KubernetesListCall;
import com.marcnuri.yakc.model.io.k8s.api.batch.v1.CronJob;
import com.marcnuri.yakc.model.io.k8s.api.batch.v1.CronJobList;
import com.marcnuri.yakc.model.io.k8s.api.batch.v1.Job;
import com.marcnuri.yakc.model.io.k8s.api.batch.v1.JobList;
import com.marcnuri.yakc.model.io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList;
import com.marcnuri.yakc.model.io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions;
import com.marcnuri.yakc.model.io.k8s.apimachinery.pkg.apis.meta.v1.Status;
import com.marcnuri.yakc.model.io.k8s.apimachinery.pkg.apis.meta.v1.WatchEvent;
import java.util.HashMap;
import retrofit2.http.Body;
import retrofit2.http.HTTP;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface BatchV1Api
extends Api {
    @HTTP(method="GET", path="/apis/batch/v1/")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<APIResourceList> getAPIResources();

    @HTTP(method="GET", path="/apis/batch/v1/cronjobs")
    @Headers(value={"Accept: */*"})
    public KubernetesListCall<CronJobList, CronJob> listCronJobForAllNamespaces();

    @HTTP(method="GET", path="/apis/batch/v1/cronjobs")
    @Headers(value={"Accept: */*"})
    public KubernetesListCall<CronJobList, CronJob> listCronJobForAllNamespaces(@QueryMap ListCronJobForAllNamespaces var1);

    @HTTP(method="GET", path="/apis/batch/v1/jobs")
    @Headers(value={"Accept: */*"})
    public KubernetesListCall<JobList, Job> listJobForAllNamespaces();

    @HTTP(method="GET", path="/apis/batch/v1/jobs")
    @Headers(value={"Accept: */*"})
    public KubernetesListCall<JobList, Job> listJobForAllNamespaces(@QueryMap ListJobForAllNamespaces var1);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/cronjobs", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteCollectionNamespacedCronJob(@Path(value="namespace") String var1, @Body DeleteOptions var2);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/cronjobs", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteCollectionNamespacedCronJob(@Path(value="namespace") String var1);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/cronjobs", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteCollectionNamespacedCronJob(@Path(value="namespace") String var1, @Body DeleteOptions var2, @QueryMap DeleteCollectionNamespacedCronJob var3);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/cronjobs", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteCollectionNamespacedCronJob(@Path(value="namespace") String var1, @QueryMap DeleteCollectionNamespacedCronJob var2);

    @HTTP(method="GET", path="/apis/batch/v1/namespaces/{namespace}/cronjobs")
    @Headers(value={"Accept: */*"})
    public KubernetesListCall<CronJobList, CronJob> listNamespacedCronJob(@Path(value="namespace") String var1);

    @HTTP(method="GET", path="/apis/batch/v1/namespaces/{namespace}/cronjobs")
    @Headers(value={"Accept: */*"})
    public KubernetesListCall<CronJobList, CronJob> listNamespacedCronJob(@Path(value="namespace") String var1, @QueryMap ListNamespacedCronJob var2);

    @HTTP(method="POST", path="/apis/batch/v1/namespaces/{namespace}/cronjobs", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<CronJob> createNamespacedCronJob(@Path(value="namespace") String var1, @Body CronJob var2);

    @HTTP(method="POST", path="/apis/batch/v1/namespaces/{namespace}/cronjobs", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<CronJob> createNamespacedCronJob(@Path(value="namespace") String var1, @Body CronJob var2, @QueryMap CreateNamespacedCronJob var3);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteNamespacedCronJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body DeleteOptions var3);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteNamespacedCronJob(@Path(value="name") String var1, @Path(value="namespace") String var2);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteNamespacedCronJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body DeleteOptions var3, @QueryMap DeleteNamespacedCronJob var4);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteNamespacedCronJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @QueryMap DeleteNamespacedCronJob var3);

    @HTTP(method="GET", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<CronJob> readNamespacedCronJob(@Path(value="name") String var1, @Path(value="namespace") String var2);

    @HTTP(method="GET", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<CronJob> readNamespacedCronJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @QueryMap ReadNamespacedCronJob var3);

    @HTTP(method="PATCH", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/merge-patch+json", "Accept: */*"})
    public KubernetesCall<CronJob> patchNamespacedCronJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body CronJob var3);

    @HTTP(method="PATCH", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/merge-patch+json", "Accept: */*"})
    public KubernetesCall<CronJob> patchNamespacedCronJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body CronJob var3, @QueryMap PatchNamespacedCronJob var4);

    @HTTP(method="PUT", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<CronJob> replaceNamespacedCronJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body CronJob var3);

    @HTTP(method="PUT", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<CronJob> replaceNamespacedCronJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body CronJob var3, @QueryMap ReplaceNamespacedCronJob var4);

    @HTTP(method="GET", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}/status")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<CronJob> readNamespacedCronJobStatus(@Path(value="name") String var1, @Path(value="namespace") String var2);

    @HTTP(method="GET", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}/status")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<CronJob> readNamespacedCronJobStatus(@Path(value="name") String var1, @Path(value="namespace") String var2, @QueryMap ReadNamespacedCronJobStatus var3);

    @HTTP(method="PATCH", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}/status", hasBody=true)
    @Headers(value={"Content-Type: application/merge-patch+json", "Accept: */*"})
    public KubernetesCall<CronJob> patchNamespacedCronJobStatus(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body CronJob var3);

    @HTTP(method="PATCH", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}/status", hasBody=true)
    @Headers(value={"Content-Type: application/merge-patch+json", "Accept: */*"})
    public KubernetesCall<CronJob> patchNamespacedCronJobStatus(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body CronJob var3, @QueryMap PatchNamespacedCronJobStatus var4);

    @HTTP(method="PUT", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}/status", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<CronJob> replaceNamespacedCronJobStatus(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body CronJob var3);

    @HTTP(method="PUT", path="/apis/batch/v1/namespaces/{namespace}/cronjobs/{name}/status", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<CronJob> replaceNamespacedCronJobStatus(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body CronJob var3, @QueryMap ReplaceNamespacedCronJobStatus var4);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/jobs", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteCollectionNamespacedJob(@Path(value="namespace") String var1, @Body DeleteOptions var2);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/jobs", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteCollectionNamespacedJob(@Path(value="namespace") String var1);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/jobs", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteCollectionNamespacedJob(@Path(value="namespace") String var1, @Body DeleteOptions var2, @QueryMap DeleteCollectionNamespacedJob var3);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/jobs", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteCollectionNamespacedJob(@Path(value="namespace") String var1, @QueryMap DeleteCollectionNamespacedJob var2);

    @HTTP(method="GET", path="/apis/batch/v1/namespaces/{namespace}/jobs")
    @Headers(value={"Accept: */*"})
    public KubernetesListCall<JobList, Job> listNamespacedJob(@Path(value="namespace") String var1);

    @HTTP(method="GET", path="/apis/batch/v1/namespaces/{namespace}/jobs")
    @Headers(value={"Accept: */*"})
    public KubernetesListCall<JobList, Job> listNamespacedJob(@Path(value="namespace") String var1, @QueryMap ListNamespacedJob var2);

    @HTTP(method="POST", path="/apis/batch/v1/namespaces/{namespace}/jobs", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Job> createNamespacedJob(@Path(value="namespace") String var1, @Body Job var2);

    @HTTP(method="POST", path="/apis/batch/v1/namespaces/{namespace}/jobs", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Job> createNamespacedJob(@Path(value="namespace") String var1, @Body Job var2, @QueryMap CreateNamespacedJob var3);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteNamespacedJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body DeleteOptions var3);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteNamespacedJob(@Path(value="name") String var1, @Path(value="namespace") String var2);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteNamespacedJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body DeleteOptions var3, @QueryMap DeleteNamespacedJob var4);

    @HTTP(method="DELETE", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteNamespacedJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @QueryMap DeleteNamespacedJob var3);

    @HTTP(method="GET", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<Job> readNamespacedJob(@Path(value="name") String var1, @Path(value="namespace") String var2);

    @HTTP(method="GET", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<Job> readNamespacedJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @QueryMap ReadNamespacedJob var3);

    @HTTP(method="PATCH", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/merge-patch+json", "Accept: */*"})
    public KubernetesCall<Job> patchNamespacedJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body Job var3);

    @HTTP(method="PATCH", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/merge-patch+json", "Accept: */*"})
    public KubernetesCall<Job> patchNamespacedJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body Job var3, @QueryMap PatchNamespacedJob var4);

    @HTTP(method="PUT", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Job> replaceNamespacedJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body Job var3);

    @HTTP(method="PUT", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Job> replaceNamespacedJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body Job var3, @QueryMap ReplaceNamespacedJob var4);

    @HTTP(method="GET", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}/status")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<Job> readNamespacedJobStatus(@Path(value="name") String var1, @Path(value="namespace") String var2);

    @HTTP(method="GET", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}/status")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<Job> readNamespacedJobStatus(@Path(value="name") String var1, @Path(value="namespace") String var2, @QueryMap ReadNamespacedJobStatus var3);

    @HTTP(method="PATCH", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}/status", hasBody=true)
    @Headers(value={"Content-Type: application/merge-patch+json", "Accept: */*"})
    public KubernetesCall<Job> patchNamespacedJobStatus(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body Job var3);

    @HTTP(method="PATCH", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}/status", hasBody=true)
    @Headers(value={"Content-Type: application/merge-patch+json", "Accept: */*"})
    public KubernetesCall<Job> patchNamespacedJobStatus(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body Job var3, @QueryMap PatchNamespacedJobStatus var4);

    @HTTP(method="PUT", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}/status", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Job> replaceNamespacedJobStatus(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body Job var3);

    @HTTP(method="PUT", path="/apis/batch/v1/namespaces/{namespace}/jobs/{name}/status", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Job> replaceNamespacedJobStatus(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body Job var3, @QueryMap ReplaceNamespacedJobStatus var4);

    @HTTP(method="GET", path="/apis/batch/v1/watch/cronjobs")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchCronJobListForAllNamespaces();

    @HTTP(method="GET", path="/apis/batch/v1/watch/cronjobs")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchCronJobListForAllNamespaces(@QueryMap WatchCronJobListForAllNamespaces var1);

    @HTTP(method="GET", path="/apis/batch/v1/watch/jobs")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchJobListForAllNamespaces();

    @HTTP(method="GET", path="/apis/batch/v1/watch/jobs")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchJobListForAllNamespaces(@QueryMap WatchJobListForAllNamespaces var1);

    @HTTP(method="GET", path="/apis/batch/v1/watch/namespaces/{namespace}/cronjobs")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchNamespacedCronJobList(@Path(value="namespace") String var1);

    @HTTP(method="GET", path="/apis/batch/v1/watch/namespaces/{namespace}/cronjobs")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchNamespacedCronJobList(@Path(value="namespace") String var1, @QueryMap WatchNamespacedCronJobList var2);

    @HTTP(method="GET", path="/apis/batch/v1/watch/namespaces/{namespace}/cronjobs/{name}")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchNamespacedCronJob(@Path(value="name") String var1, @Path(value="namespace") String var2);

    @HTTP(method="GET", path="/apis/batch/v1/watch/namespaces/{namespace}/cronjobs/{name}")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchNamespacedCronJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @QueryMap WatchNamespacedCronJob var3);

    @HTTP(method="GET", path="/apis/batch/v1/watch/namespaces/{namespace}/jobs")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchNamespacedJobList(@Path(value="namespace") String var1);

    @HTTP(method="GET", path="/apis/batch/v1/watch/namespaces/{namespace}/jobs")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchNamespacedJobList(@Path(value="namespace") String var1, @QueryMap WatchNamespacedJobList var2);

    @HTTP(method="GET", path="/apis/batch/v1/watch/namespaces/{namespace}/jobs/{name}")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchNamespacedJob(@Path(value="name") String var1, @Path(value="namespace") String var2);

    @HTTP(method="GET", path="/apis/batch/v1/watch/namespaces/{namespace}/jobs/{name}")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchNamespacedJob(@Path(value="name") String var1, @Path(value="namespace") String var2, @QueryMap WatchNamespacedJob var3);

    public static final class WatchNamespacedJob
    extends HashMap<String, Object> {
        public WatchNamespacedJob allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public WatchNamespacedJob continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public WatchNamespacedJob fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public WatchNamespacedJob labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public WatchNamespacedJob limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public WatchNamespacedJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public WatchNamespacedJob resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public WatchNamespacedJob resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public WatchNamespacedJob timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public WatchNamespacedJob watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }

    public static final class WatchNamespacedJobList
    extends HashMap<String, Object> {
        public WatchNamespacedJobList allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public WatchNamespacedJobList continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public WatchNamespacedJobList fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public WatchNamespacedJobList labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public WatchNamespacedJobList limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public WatchNamespacedJobList pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public WatchNamespacedJobList resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public WatchNamespacedJobList resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public WatchNamespacedJobList timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public WatchNamespacedJobList watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }

    public static final class WatchNamespacedCronJob
    extends HashMap<String, Object> {
        public WatchNamespacedCronJob allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public WatchNamespacedCronJob continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public WatchNamespacedCronJob fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public WatchNamespacedCronJob labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public WatchNamespacedCronJob limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public WatchNamespacedCronJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public WatchNamespacedCronJob resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public WatchNamespacedCronJob resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public WatchNamespacedCronJob timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public WatchNamespacedCronJob watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }

    public static final class WatchNamespacedCronJobList
    extends HashMap<String, Object> {
        public WatchNamespacedCronJobList allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public WatchNamespacedCronJobList continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public WatchNamespacedCronJobList fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public WatchNamespacedCronJobList labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public WatchNamespacedCronJobList limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public WatchNamespacedCronJobList pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public WatchNamespacedCronJobList resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public WatchNamespacedCronJobList resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public WatchNamespacedCronJobList timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public WatchNamespacedCronJobList watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }

    public static final class WatchJobListForAllNamespaces
    extends HashMap<String, Object> {
        public WatchJobListForAllNamespaces allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public WatchJobListForAllNamespaces continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public WatchJobListForAllNamespaces fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public WatchJobListForAllNamespaces labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public WatchJobListForAllNamespaces limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public WatchJobListForAllNamespaces pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public WatchJobListForAllNamespaces resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public WatchJobListForAllNamespaces resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public WatchJobListForAllNamespaces timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public WatchJobListForAllNamespaces watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }

    public static final class WatchCronJobListForAllNamespaces
    extends HashMap<String, Object> {
        public WatchCronJobListForAllNamespaces allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public WatchCronJobListForAllNamespaces continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public WatchCronJobListForAllNamespaces fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public WatchCronJobListForAllNamespaces labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public WatchCronJobListForAllNamespaces limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public WatchCronJobListForAllNamespaces pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public WatchCronJobListForAllNamespaces resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public WatchCronJobListForAllNamespaces resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public WatchCronJobListForAllNamespaces timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public WatchCronJobListForAllNamespaces watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }

    public static final class ReplaceNamespacedJobStatus
    extends HashMap<String, Object> {
        public ReplaceNamespacedJobStatus pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public ReplaceNamespacedJobStatus dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public ReplaceNamespacedJobStatus fieldManager(String fieldManager) {
            this.put("fieldManager", fieldManager);
            return this;
        }
    }

    public static final class PatchNamespacedJobStatus
    extends HashMap<String, Object> {
        public PatchNamespacedJobStatus pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public PatchNamespacedJobStatus dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public PatchNamespacedJobStatus fieldManager(String fieldManager) {
            this.put("fieldManager", fieldManager);
            return this;
        }

        public PatchNamespacedJobStatus force(Boolean force) {
            this.put("force", force);
            return this;
        }
    }

    public static final class ReadNamespacedJobStatus
    extends HashMap<String, Object> {
        public ReadNamespacedJobStatus pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }
    }

    public static final class ReplaceNamespacedJob
    extends HashMap<String, Object> {
        public ReplaceNamespacedJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public ReplaceNamespacedJob dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public ReplaceNamespacedJob fieldManager(String fieldManager) {
            this.put("fieldManager", fieldManager);
            return this;
        }
    }

    public static final class PatchNamespacedJob
    extends HashMap<String, Object> {
        public PatchNamespacedJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public PatchNamespacedJob dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public PatchNamespacedJob fieldManager(String fieldManager) {
            this.put("fieldManager", fieldManager);
            return this;
        }

        public PatchNamespacedJob force(Boolean force) {
            this.put("force", force);
            return this;
        }
    }

    public static final class ReadNamespacedJob
    extends HashMap<String, Object> {
        public ReadNamespacedJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }
    }

    public static final class DeleteNamespacedJob
    extends HashMap<String, Object> {
        public DeleteNamespacedJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public DeleteNamespacedJob dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public DeleteNamespacedJob gracePeriodSeconds(Number gracePeriodSeconds) {
            this.put("gracePeriodSeconds", gracePeriodSeconds);
            return this;
        }

        public DeleteNamespacedJob orphanDependents(Boolean orphanDependents) {
            this.put("orphanDependents", orphanDependents);
            return this;
        }

        public DeleteNamespacedJob propagationPolicy(String propagationPolicy) {
            this.put("propagationPolicy", propagationPolicy);
            return this;
        }
    }

    public static final class CreateNamespacedJob
    extends HashMap<String, Object> {
        public CreateNamespacedJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public CreateNamespacedJob dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public CreateNamespacedJob fieldManager(String fieldManager) {
            this.put("fieldManager", fieldManager);
            return this;
        }
    }

    public static final class ListNamespacedJob
    extends HashMap<String, Object> {
        public ListNamespacedJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public ListNamespacedJob allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public ListNamespacedJob continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public ListNamespacedJob fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public ListNamespacedJob labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public ListNamespacedJob limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public ListNamespacedJob resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public ListNamespacedJob resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public ListNamespacedJob timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public ListNamespacedJob watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }

    public static final class DeleteCollectionNamespacedJob
    extends HashMap<String, Object> {
        public DeleteCollectionNamespacedJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public DeleteCollectionNamespacedJob continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public DeleteCollectionNamespacedJob dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public DeleteCollectionNamespacedJob fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public DeleteCollectionNamespacedJob gracePeriodSeconds(Number gracePeriodSeconds) {
            this.put("gracePeriodSeconds", gracePeriodSeconds);
            return this;
        }

        public DeleteCollectionNamespacedJob labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public DeleteCollectionNamespacedJob limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public DeleteCollectionNamespacedJob orphanDependents(Boolean orphanDependents) {
            this.put("orphanDependents", orphanDependents);
            return this;
        }

        public DeleteCollectionNamespacedJob propagationPolicy(String propagationPolicy) {
            this.put("propagationPolicy", propagationPolicy);
            return this;
        }

        public DeleteCollectionNamespacedJob resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public DeleteCollectionNamespacedJob resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public DeleteCollectionNamespacedJob timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }
    }

    public static final class ReplaceNamespacedCronJobStatus
    extends HashMap<String, Object> {
        public ReplaceNamespacedCronJobStatus pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public ReplaceNamespacedCronJobStatus dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public ReplaceNamespacedCronJobStatus fieldManager(String fieldManager) {
            this.put("fieldManager", fieldManager);
            return this;
        }
    }

    public static final class PatchNamespacedCronJobStatus
    extends HashMap<String, Object> {
        public PatchNamespacedCronJobStatus pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public PatchNamespacedCronJobStatus dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public PatchNamespacedCronJobStatus fieldManager(String fieldManager) {
            this.put("fieldManager", fieldManager);
            return this;
        }

        public PatchNamespacedCronJobStatus force(Boolean force) {
            this.put("force", force);
            return this;
        }
    }

    public static final class ReadNamespacedCronJobStatus
    extends HashMap<String, Object> {
        public ReadNamespacedCronJobStatus pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }
    }

    public static final class ReplaceNamespacedCronJob
    extends HashMap<String, Object> {
        public ReplaceNamespacedCronJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public ReplaceNamespacedCronJob dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public ReplaceNamespacedCronJob fieldManager(String fieldManager) {
            this.put("fieldManager", fieldManager);
            return this;
        }
    }

    public static final class PatchNamespacedCronJob
    extends HashMap<String, Object> {
        public PatchNamespacedCronJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public PatchNamespacedCronJob dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public PatchNamespacedCronJob fieldManager(String fieldManager) {
            this.put("fieldManager", fieldManager);
            return this;
        }

        public PatchNamespacedCronJob force(Boolean force) {
            this.put("force", force);
            return this;
        }
    }

    public static final class ReadNamespacedCronJob
    extends HashMap<String, Object> {
        public ReadNamespacedCronJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }
    }

    public static final class DeleteNamespacedCronJob
    extends HashMap<String, Object> {
        public DeleteNamespacedCronJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public DeleteNamespacedCronJob dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public DeleteNamespacedCronJob gracePeriodSeconds(Number gracePeriodSeconds) {
            this.put("gracePeriodSeconds", gracePeriodSeconds);
            return this;
        }

        public DeleteNamespacedCronJob orphanDependents(Boolean orphanDependents) {
            this.put("orphanDependents", orphanDependents);
            return this;
        }

        public DeleteNamespacedCronJob propagationPolicy(String propagationPolicy) {
            this.put("propagationPolicy", propagationPolicy);
            return this;
        }
    }

    public static final class CreateNamespacedCronJob
    extends HashMap<String, Object> {
        public CreateNamespacedCronJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public CreateNamespacedCronJob dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public CreateNamespacedCronJob fieldManager(String fieldManager) {
            this.put("fieldManager", fieldManager);
            return this;
        }
    }

    public static final class ListNamespacedCronJob
    extends HashMap<String, Object> {
        public ListNamespacedCronJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public ListNamespacedCronJob allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public ListNamespacedCronJob continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public ListNamespacedCronJob fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public ListNamespacedCronJob labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public ListNamespacedCronJob limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public ListNamespacedCronJob resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public ListNamespacedCronJob resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public ListNamespacedCronJob timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public ListNamespacedCronJob watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }

    public static final class DeleteCollectionNamespacedCronJob
    extends HashMap<String, Object> {
        public DeleteCollectionNamespacedCronJob pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public DeleteCollectionNamespacedCronJob continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public DeleteCollectionNamespacedCronJob dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public DeleteCollectionNamespacedCronJob fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public DeleteCollectionNamespacedCronJob gracePeriodSeconds(Number gracePeriodSeconds) {
            this.put("gracePeriodSeconds", gracePeriodSeconds);
            return this;
        }

        public DeleteCollectionNamespacedCronJob labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public DeleteCollectionNamespacedCronJob limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public DeleteCollectionNamespacedCronJob orphanDependents(Boolean orphanDependents) {
            this.put("orphanDependents", orphanDependents);
            return this;
        }

        public DeleteCollectionNamespacedCronJob propagationPolicy(String propagationPolicy) {
            this.put("propagationPolicy", propagationPolicy);
            return this;
        }

        public DeleteCollectionNamespacedCronJob resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public DeleteCollectionNamespacedCronJob resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public DeleteCollectionNamespacedCronJob timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }
    }

    public static final class ListJobForAllNamespaces
    extends HashMap<String, Object> {
        public ListJobForAllNamespaces allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public ListJobForAllNamespaces continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public ListJobForAllNamespaces fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public ListJobForAllNamespaces labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public ListJobForAllNamespaces limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public ListJobForAllNamespaces pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public ListJobForAllNamespaces resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public ListJobForAllNamespaces resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public ListJobForAllNamespaces timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public ListJobForAllNamespaces watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }

    public static final class ListCronJobForAllNamespaces
    extends HashMap<String, Object> {
        public ListCronJobForAllNamespaces allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public ListCronJobForAllNamespaces continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public ListCronJobForAllNamespaces fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public ListCronJobForAllNamespaces labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public ListCronJobForAllNamespaces limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public ListCronJobForAllNamespaces pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public ListCronJobForAllNamespaces resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public ListCronJobForAllNamespaces resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public ListCronJobForAllNamespaces timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public ListCronJobForAllNamespaces watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }
}

