/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.yakc.api.discovery.v1;

import com.marcnuri.yakc.api.Api;
import com.marcnuri.yakc.api.KubernetesCall;
import com.marcnuri.yakc.api.KubernetesListCall;
import com.marcnuri.yakc.model.io.k8s.api.discovery.v1.EndpointSlice;
import com.marcnuri.yakc.model.io.k8s.api.discovery.v1.EndpointSliceList;
import com.marcnuri.yakc.model.io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList;
import com.marcnuri.yakc.model.io.k8s.apimachinery.pkg.apis.meta.v1.DeleteOptions;
import com.marcnuri.yakc.model.io.k8s.apimachinery.pkg.apis.meta.v1.Status;
import com.marcnuri.yakc.model.io.k8s.apimachinery.pkg.apis.meta.v1.WatchEvent;
import java.util.HashMap;
import retrofit2.http.Body;
import retrofit2.http.HTTP;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface DiscoveryV1Api
extends Api {
    @HTTP(method="GET", path="/apis/discovery.k8s.io/v1/")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<APIResourceList> getAPIResources();

    @HTTP(method="GET", path="/apis/discovery.k8s.io/v1/endpointslices")
    @Headers(value={"Accept: */*"})
    public KubernetesListCall<EndpointSliceList, EndpointSlice> listEndpointSliceForAllNamespaces();

    @HTTP(method="GET", path="/apis/discovery.k8s.io/v1/endpointslices")
    @Headers(value={"Accept: */*"})
    public KubernetesListCall<EndpointSliceList, EndpointSlice> listEndpointSliceForAllNamespaces(@QueryMap ListEndpointSliceForAllNamespaces var1);

    @HTTP(method="DELETE", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteCollectionNamespacedEndpointSlice(@Path(value="namespace") String var1, @Body DeleteOptions var2);

    @HTTP(method="DELETE", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteCollectionNamespacedEndpointSlice(@Path(value="namespace") String var1);

    @HTTP(method="DELETE", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteCollectionNamespacedEndpointSlice(@Path(value="namespace") String var1, @Body DeleteOptions var2, @QueryMap DeleteCollectionNamespacedEndpointSlice var3);

    @HTTP(method="DELETE", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteCollectionNamespacedEndpointSlice(@Path(value="namespace") String var1, @QueryMap DeleteCollectionNamespacedEndpointSlice var2);

    @HTTP(method="GET", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices")
    @Headers(value={"Accept: */*"})
    public KubernetesListCall<EndpointSliceList, EndpointSlice> listNamespacedEndpointSlice(@Path(value="namespace") String var1);

    @HTTP(method="GET", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices")
    @Headers(value={"Accept: */*"})
    public KubernetesListCall<EndpointSliceList, EndpointSlice> listNamespacedEndpointSlice(@Path(value="namespace") String var1, @QueryMap ListNamespacedEndpointSlice var2);

    @HTTP(method="POST", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<EndpointSlice> createNamespacedEndpointSlice(@Path(value="namespace") String var1, @Body EndpointSlice var2);

    @HTTP(method="POST", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<EndpointSlice> createNamespacedEndpointSlice(@Path(value="namespace") String var1, @Body EndpointSlice var2, @QueryMap CreateNamespacedEndpointSlice var3);

    @HTTP(method="DELETE", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteNamespacedEndpointSlice(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body DeleteOptions var3);

    @HTTP(method="DELETE", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteNamespacedEndpointSlice(@Path(value="name") String var1, @Path(value="namespace") String var2);

    @HTTP(method="DELETE", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteNamespacedEndpointSlice(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body DeleteOptions var3, @QueryMap DeleteNamespacedEndpointSlice var4);

    @HTTP(method="DELETE", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<Status> deleteNamespacedEndpointSlice(@Path(value="name") String var1, @Path(value="namespace") String var2, @QueryMap DeleteNamespacedEndpointSlice var3);

    @HTTP(method="GET", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name}")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<EndpointSlice> readNamespacedEndpointSlice(@Path(value="name") String var1, @Path(value="namespace") String var2);

    @HTTP(method="GET", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name}")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<EndpointSlice> readNamespacedEndpointSlice(@Path(value="name") String var1, @Path(value="namespace") String var2, @QueryMap ReadNamespacedEndpointSlice var3);

    @HTTP(method="PATCH", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/merge-patch+json", "Accept: */*"})
    public KubernetesCall<EndpointSlice> patchNamespacedEndpointSlice(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body EndpointSlice var3);

    @HTTP(method="PATCH", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/merge-patch+json", "Accept: */*"})
    public KubernetesCall<EndpointSlice> patchNamespacedEndpointSlice(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body EndpointSlice var3, @QueryMap PatchNamespacedEndpointSlice var4);

    @HTTP(method="PUT", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<EndpointSlice> replaceNamespacedEndpointSlice(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body EndpointSlice var3);

    @HTTP(method="PUT", path="/apis/discovery.k8s.io/v1/namespaces/{namespace}/endpointslices/{name}", hasBody=true)
    @Headers(value={"Content-Type: application/json", "Accept: */*"})
    public KubernetesCall<EndpointSlice> replaceNamespacedEndpointSlice(@Path(value="name") String var1, @Path(value="namespace") String var2, @Body EndpointSlice var3, @QueryMap ReplaceNamespacedEndpointSlice var4);

    @HTTP(method="GET", path="/apis/discovery.k8s.io/v1/watch/endpointslices")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchEndpointSliceListForAllNamespaces();

    @HTTP(method="GET", path="/apis/discovery.k8s.io/v1/watch/endpointslices")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchEndpointSliceListForAllNamespaces(@QueryMap WatchEndpointSliceListForAllNamespaces var1);

    @HTTP(method="GET", path="/apis/discovery.k8s.io/v1/watch/namespaces/{namespace}/endpointslices")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchNamespacedEndpointSliceList(@Path(value="namespace") String var1);

    @HTTP(method="GET", path="/apis/discovery.k8s.io/v1/watch/namespaces/{namespace}/endpointslices")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchNamespacedEndpointSliceList(@Path(value="namespace") String var1, @QueryMap WatchNamespacedEndpointSliceList var2);

    @HTTP(method="GET", path="/apis/discovery.k8s.io/v1/watch/namespaces/{namespace}/endpointslices/{name}")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchNamespacedEndpointSlice(@Path(value="name") String var1, @Path(value="namespace") String var2);

    @HTTP(method="GET", path="/apis/discovery.k8s.io/v1/watch/namespaces/{namespace}/endpointslices/{name}")
    @Headers(value={"Accept: */*"})
    public KubernetesCall<WatchEvent> watchNamespacedEndpointSlice(@Path(value="name") String var1, @Path(value="namespace") String var2, @QueryMap WatchNamespacedEndpointSlice var3);

    public static final class WatchNamespacedEndpointSlice
    extends HashMap<String, Object> {
        public WatchNamespacedEndpointSlice allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public WatchNamespacedEndpointSlice continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public WatchNamespacedEndpointSlice fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public WatchNamespacedEndpointSlice labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public WatchNamespacedEndpointSlice limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public WatchNamespacedEndpointSlice pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public WatchNamespacedEndpointSlice resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public WatchNamespacedEndpointSlice resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public WatchNamespacedEndpointSlice timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public WatchNamespacedEndpointSlice watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }

    public static final class WatchNamespacedEndpointSliceList
    extends HashMap<String, Object> {
        public WatchNamespacedEndpointSliceList allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public WatchNamespacedEndpointSliceList continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public WatchNamespacedEndpointSliceList fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public WatchNamespacedEndpointSliceList labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public WatchNamespacedEndpointSliceList limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public WatchNamespacedEndpointSliceList pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public WatchNamespacedEndpointSliceList resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public WatchNamespacedEndpointSliceList resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public WatchNamespacedEndpointSliceList timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public WatchNamespacedEndpointSliceList watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }

    public static final class WatchEndpointSliceListForAllNamespaces
    extends HashMap<String, Object> {
        public WatchEndpointSliceListForAllNamespaces allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public WatchEndpointSliceListForAllNamespaces continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public WatchEndpointSliceListForAllNamespaces fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public WatchEndpointSliceListForAllNamespaces labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public WatchEndpointSliceListForAllNamespaces limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public WatchEndpointSliceListForAllNamespaces pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public WatchEndpointSliceListForAllNamespaces resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public WatchEndpointSliceListForAllNamespaces resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public WatchEndpointSliceListForAllNamespaces timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public WatchEndpointSliceListForAllNamespaces watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }

    public static final class ReplaceNamespacedEndpointSlice
    extends HashMap<String, Object> {
        public ReplaceNamespacedEndpointSlice pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public ReplaceNamespacedEndpointSlice dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public ReplaceNamespacedEndpointSlice fieldManager(String fieldManager) {
            this.put("fieldManager", fieldManager);
            return this;
        }
    }

    public static final class PatchNamespacedEndpointSlice
    extends HashMap<String, Object> {
        public PatchNamespacedEndpointSlice pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public PatchNamespacedEndpointSlice dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public PatchNamespacedEndpointSlice fieldManager(String fieldManager) {
            this.put("fieldManager", fieldManager);
            return this;
        }

        public PatchNamespacedEndpointSlice force(Boolean force) {
            this.put("force", force);
            return this;
        }
    }

    public static final class ReadNamespacedEndpointSlice
    extends HashMap<String, Object> {
        public ReadNamespacedEndpointSlice pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }
    }

    public static final class DeleteNamespacedEndpointSlice
    extends HashMap<String, Object> {
        public DeleteNamespacedEndpointSlice pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public DeleteNamespacedEndpointSlice dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public DeleteNamespacedEndpointSlice gracePeriodSeconds(Number gracePeriodSeconds) {
            this.put("gracePeriodSeconds", gracePeriodSeconds);
            return this;
        }

        public DeleteNamespacedEndpointSlice orphanDependents(Boolean orphanDependents) {
            this.put("orphanDependents", orphanDependents);
            return this;
        }

        public DeleteNamespacedEndpointSlice propagationPolicy(String propagationPolicy) {
            this.put("propagationPolicy", propagationPolicy);
            return this;
        }
    }

    public static final class CreateNamespacedEndpointSlice
    extends HashMap<String, Object> {
        public CreateNamespacedEndpointSlice pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public CreateNamespacedEndpointSlice dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public CreateNamespacedEndpointSlice fieldManager(String fieldManager) {
            this.put("fieldManager", fieldManager);
            return this;
        }
    }

    public static final class ListNamespacedEndpointSlice
    extends HashMap<String, Object> {
        public ListNamespacedEndpointSlice pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public ListNamespacedEndpointSlice allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public ListNamespacedEndpointSlice continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public ListNamespacedEndpointSlice fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public ListNamespacedEndpointSlice labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public ListNamespacedEndpointSlice limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public ListNamespacedEndpointSlice resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public ListNamespacedEndpointSlice resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public ListNamespacedEndpointSlice timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public ListNamespacedEndpointSlice watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }

    public static final class DeleteCollectionNamespacedEndpointSlice
    extends HashMap<String, Object> {
        public DeleteCollectionNamespacedEndpointSlice pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public DeleteCollectionNamespacedEndpointSlice continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public DeleteCollectionNamespacedEndpointSlice dryRun(String dryRun) {
            this.put("dryRun", dryRun);
            return this;
        }

        public DeleteCollectionNamespacedEndpointSlice fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public DeleteCollectionNamespacedEndpointSlice gracePeriodSeconds(Number gracePeriodSeconds) {
            this.put("gracePeriodSeconds", gracePeriodSeconds);
            return this;
        }

        public DeleteCollectionNamespacedEndpointSlice labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public DeleteCollectionNamespacedEndpointSlice limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public DeleteCollectionNamespacedEndpointSlice orphanDependents(Boolean orphanDependents) {
            this.put("orphanDependents", orphanDependents);
            return this;
        }

        public DeleteCollectionNamespacedEndpointSlice propagationPolicy(String propagationPolicy) {
            this.put("propagationPolicy", propagationPolicy);
            return this;
        }

        public DeleteCollectionNamespacedEndpointSlice resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public DeleteCollectionNamespacedEndpointSlice resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public DeleteCollectionNamespacedEndpointSlice timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }
    }

    public static final class ListEndpointSliceForAllNamespaces
    extends HashMap<String, Object> {
        public ListEndpointSliceForAllNamespaces allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.put("allowWatchBookmarks", allowWatchBookmarks);
            return this;
        }

        public ListEndpointSliceForAllNamespaces continues(String continues) {
            this.put("continue", continues);
            return this;
        }

        public ListEndpointSliceForAllNamespaces fieldSelector(String fieldSelector) {
            this.put("fieldSelector", fieldSelector);
            return this;
        }

        public ListEndpointSliceForAllNamespaces labelSelector(String labelSelector) {
            this.put("labelSelector", labelSelector);
            return this;
        }

        public ListEndpointSliceForAllNamespaces limit(Number limit) {
            this.put("limit", limit);
            return this;
        }

        public ListEndpointSliceForAllNamespaces pretty(String pretty) {
            this.put("pretty", pretty);
            return this;
        }

        public ListEndpointSliceForAllNamespaces resourceVersion(String resourceVersion) {
            this.put("resourceVersion", resourceVersion);
            return this;
        }

        public ListEndpointSliceForAllNamespaces resourceVersionMatch(String resourceVersionMatch) {
            this.put("resourceVersionMatch", resourceVersionMatch);
            return this;
        }

        public ListEndpointSliceForAllNamespaces timeoutSeconds(Number timeoutSeconds) {
            this.put("timeoutSeconds", timeoutSeconds);
            return this;
        }

        public ListEndpointSliceForAllNamespaces watch(Boolean watch) {
            this.put("watch", watch);
            return this;
        }
    }
}

