/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.yakc.api;

import com.marcnuri.yakc.api.ClientErrorException;
import com.marcnuri.yakc.api.ForbiddenException;
import com.marcnuri.yakc.api.NotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Response;

public class KubernetesException
extends IOException {
    private static final Map<Integer, Class<? extends KubernetesException>> EXCEPTIONS = new HashMap<Integer, Class<? extends KubernetesException>>();
    private final transient Response rawResponse;

    public KubernetesException(String message, Response rawResponse) {
        super(message);
        this.rawResponse = rawResponse;
    }

    public int getCode() {
        return this.rawResponse.code();
    }

    public static KubernetesException forResponse(String message, Response rawResponse) {
        int statusCode = rawResponse.code();
        if (EXCEPTIONS.containsKey(rawResponse.code())) {
            try {
                return EXCEPTIONS.get(rawResponse.code()).getConstructor(String.class, Response.class).newInstance(message, rawResponse);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Problem when generating KuberentesException", e);
            }
        }
        if (statusCode >= 400 && statusCode < 500) {
            return new ClientErrorException(message, rawResponse);
        }
        return new KubernetesException(message, rawResponse);
    }

    static {
        EXCEPTIONS.put(403, ForbiddenException.class);
        EXCEPTIONS.put(404, NotFoundException.class);
    }
}

