/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteurbase;

import com.mastfrog.acteurbase.AbstractActeur;
import java.util.Arrays;

public class ActeurState<T, R extends T> {
    private final Object[] context;
    private final boolean rejected;
    AbstractActeur<T, R, ?> acteur;
    protected Throwable creationStackTrace;

    private ActeurState(boolean rejected, Object ... context) {
        this.context = context;
        this.rejected = rejected;
        boolean asserts = false;
        if (!$assertionsDisabled) {
            asserts = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (asserts) {
            this.creationStackTrace = new Throwable();
        }
    }

    public ActeurState(Object ... context) {
        this(false, context);
    }

    public ActeurState(boolean rejected) {
        this(rejected, (Object[])null);
    }

    protected boolean isRejected() {
        return this.rejected;
    }

    protected Object[] context() {
        return this.context;
    }

    protected AbstractActeur<T, R, ?> getActeur() {
        return this.acteur;
    }

    public boolean isFinished() {
        AbstractActeur<T, R, ?> acteur = this.getActeur();
        if (this.getActeur() == null) {
            IllegalStateException ex = new IllegalStateException(this.getClass().getName() + " does not have its acteur set");
            if (this.creationStackTrace != null) {
                ex.initCause(this.creationStackTrace);
            }
            ex.printStackTrace();
            throw ex;
        }
        R r = this.getActeur().getResponse();
        return r != null && this.getActeur().factory.isFinished(r);
    }

    R response() {
        R r = this.getActeur().getResponse();
        return r != null && this.getActeur().factory.isModified(r) ? (R)r : null;
    }

    public String toString() {
        return this.getClass().getName() + " rej? " + this.rejected + " for " + this.getActeur() + " with " + (this.context == null ? " (none0)" : Arrays.asList(this.context).toString());
    }
}

