/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteurbase;

import com.mastfrog.acteurbase.Chain;
import com.mastfrog.acteurbase.InstantiatingIterators;
import com.mastfrog.giulius.Dependencies;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.ConfigurationError;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class ArrayChain<T, C extends ArrayChain<T, C>>
implements Chain<T, C> {
    protected final List<Object> types = new LinkedList<Object>();
    protected final Dependencies deps;
    protected final Class<? super T> type;
    protected AtomicInteger chainPosition;

    public ArrayChain(Dependencies deps, Class<? super T> type, List<Object> objs) {
        this(deps, type);
        for (Object o : objs) {
            if (o == null) {
                throw new ConfigurationError("Null in acteur list");
            }
            if (o instanceof Class) {
                Class c = (Class)o;
                if (!type.isAssignableFrom(c)) {
                    throw new ConfigurationError(c.getName() + " is not a subtype of " + type.getName());
                }
                this.add((Class)o);
                continue;
            }
            T t = type.cast(o);
            this.add((Object)t);
        }
    }

    public ArrayChain(Dependencies deps, Class<? super T> type) {
        Checks.notNull((String)"deps", (Object)deps);
        Checks.notNull((String)"type", type);
        this.deps = deps;
        this.type = type;
    }

    @Override
    public Supplier<C> remnantSupplier(Object ... scopeContents) {
        assert (this.chainPosition != null) : "Called out of sequence";
        int pos = this.chainPosition.get();
        ArrayList<Object> rem = new ArrayList<Object>(this.types.size() - pos);
        for (int i = pos; i < this.types.size(); ++i) {
            rem.add(this.types.get(i));
        }
        return () -> {
            ArrayList<Object> l = new ArrayList<Object>(rem);
            return new ArrayChain<T, C>(this.deps, this.type, l);
        };
    }

    @Override
    public final C add(Class<? extends T> type) {
        Checks.notNull((String)"type", type);
        if (!this.type.isAssignableFrom(type)) {
            throw new ConfigurationError(type.getName() + " is not a " + this.type.getName());
        }
        if ((type.getModifiers() & 0x400) != 0) {
            throw new ConfigurationError(type + " is abstract");
        }
        if (type.isLocalClass()) {
            throw new ConfigurationError(type + " is an inner class");
        }
        if (type.isArray()) {
            throw new ConfigurationError(type + " is an array type");
        }
        if (type.isAnnotation()) {
            throw new ConfigurationError(type + " is an annotation type");
        }
        this.types.add(type);
        return (C)this;
    }

    private boolean validElement(Object obj) {
        Class c;
        if (this.type.isInstance(obj)) {
            return true;
        }
        return obj instanceof Class && this.type.isAssignableFrom(c = (Class)obj);
    }

    @Override
    public final C insert(T obj) {
        Checks.notNull((String)"obj", obj);
        if (!this.validElement(obj)) {
            throw new ConfigurationError("Not an instance of " + this.type.getName() + ": " + obj);
        }
        int pos = this.chainPosition.get();
        this.types.add(pos, obj);
        return (C)this;
    }

    @Override
    public final C add(T obj) {
        Checks.notNull((String)"obj", obj);
        if (!this.validElement(obj)) {
            throw new ConfigurationError("Not an instance of " + this.type.getName() + ": " + obj);
        }
        this.types.add(obj);
        return (C)this;
    }

    @Override
    public Iterator<T> iterator() {
        this.chainPosition = new AtomicInteger();
        return new InstantiatingIterators(this.deps, this.chainPosition).iterable(this.types, this.type).iterator();
    }
}

