/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteurbase;

import com.google.inject.ProvisionException;
import com.mastfrog.acteurbase.AbstractActeur;
import com.mastfrog.acteurbase.ActeurState;
import com.mastfrog.acteurbase.Chain;
import com.mastfrog.acteurbase.ChainCallback;
import com.mastfrog.acteurbase.Deferral;
import com.mastfrog.giulius.scope.ReentrantScope;
import com.mastfrog.util.preconditions.Checks;
import com.mastfrog.util.preconditions.Exceptions;
import com.mastfrog.util.thread.QuietAutoCloseable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;

public final class ChainRunner {
    private final ExecutorService svc;
    private final ReentrantScope scope;
    private static final boolean firstSync = Boolean.getBoolean("acteur.chain.init.sync");
    private static final boolean allSync = Boolean.getBoolean("acteur.unsupported.sync");

    @Inject
    public ChainRunner(ExecutorService svc, ReentrantScope scope) {
        Checks.notNull((String)"svc", (Object)svc);
        Checks.notNull((String)"scope", (Object)scope);
        this.svc = svc;
        this.scope = scope;
    }

    public <A extends AbstractActeur<T, R, S>, S extends ActeurState<T, R>, P extends Chain<? extends A, ?>, T, R extends T> void submit(P chain, ChainCallback<A, S, P, T, R> onDone, AtomicBoolean cancelled) {
        ActeurInvoker<A, S, P, T, R> cc = new ActeurInvoker<A, S, P, T, R>(this.svc, this.scope, chain, onDone, cancelled);
        try (QuietAutoCloseable ac = this.scope.enter(new Object[]{chain, cc.deferral});){
            if (firstSync) {
                try {
                    cc.call();
                }
                catch (Exception ex) {
                    Exceptions.chuck((Throwable)ex);
                }
            } else {
                this.svc.submit(this.scope.wrap(cc));
            }
        }
    }

    private static class ActeurInvoker<A extends AbstractActeur<T, R, S>, S extends ActeurState<T, R>, P extends Chain<? extends A, ?>, T, R extends T>
    implements Callable<Void>,
    Deferral.Resumer {
        private final ExecutorService svc;
        private final ReentrantScope scope;
        private final Iterator<? extends A> iter;
        private Object[] state = new Object[0];
        private final List<R> responses = new LinkedList<R>();
        private final ChainCallback<A, S, P, T, R> onDone;
        private final AtomicBoolean deferred = new AtomicBoolean();
        private Callable<?> next;
        final DeferralImpl deferral = new DeferralImpl();
        private final P chain;
        private final AtomicBoolean cancelled;
        private final AtomicReference<Deferral.DeferredCode> deferredCode = new AtomicReference();

        public ActeurInvoker(ExecutorService svc, ReentrantScope scope, P chain, ChainCallback<A, S, P, T, R> onDone, AtomicBoolean cancelled) {
            this.svc = svc;
            this.scope = scope;
            this.iter = chain.iterator();
            this.chain = chain;
            this.onDone = onDone;
            this.cancelled = cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addToContext(ActeurState state) {
            ActeurInvoker acteurInvoker = this;
            synchronized (acteurInvoker) {
                this.addToContext(state.context());
            }
        }

        private synchronized void addToContext(Object[] ctx) {
            if (ctx != null && ctx.length > 0) {
                Object[] nue = new Object[this.state.length + ctx.length];
                System.arraycopy(this.state, 0, nue, 0, this.state.length);
                System.arraycopy(ctx, 0, nue, this.state.length, ctx.length);
                this.state = nue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Void call() throws Exception {
            if (this.cancelled.get()) {
                return null;
            }
            try (QuietAutoCloseable ctx = this.scope.enter(this.chain.getContextContribution());){
                block56: {
                    ActeurState newState;
                    block57: {
                        block59: {
                            block58: {
                                QuietAutoCloseable ac = null;
                                ActeurInvoker acteurInvoker = this;
                                synchronized (acteurInvoker) {
                                    if (this.state.length > 0) {
                                        ac = this.scope.enter(this.state);
                                    }
                                }
                                newState = null;
                                try {
                                    AbstractActeur a2 = null;
                                    this.onDone.onBeforeRunOne(this.chain);
                                    this.onDone.onBeforeRunOne(this.chain, this.responses);
                                    a2 = (AbstractActeur)this.iter.next();
                                    newState = (ActeurState)a2.getState();
                                    this.onDone.onAfterRunOne(this.chain, a2, newState);
                                    this.addToContext(newState);
                                    if (newState.isRejected()) {
                                        this.onDone.onRejected(newState);
                                        Void void_ = null;
                                        return void_;
                                    }
                                }
                                catch (Error | Exception e) {
                                    Throwable t = e;
                                    if (e instanceof ProvisionException && e.getCause() != null) {
                                        t = e.getCause();
                                    }
                                    this.onDone.onFailure(t);
                                    Void void_ = null;
                                    return void_;
                                }
                                finally {
                                    if (ac != null) {
                                        ac.close();
                                    }
                                }
                                if (this.cancelled.get()) {
                                    Void e = null;
                                    return e;
                                }
                                Object resp = newState.response();
                                if (resp != null) {
                                    ActeurInvoker t = this;
                                    synchronized (t) {
                                        this.responses.add(resp);
                                    }
                                }
                                if (newState.isFinished()) break block57;
                                if (this.iter.hasNext()) break block58;
                                this.onDone.onNoResponse();
                                break block56;
                            }
                            if (!this.deferred.get()) break block59;
                            Deferral.DeferredCode code = this.deferredCode.getAndSet(null);
                            this.next = this.scope.wrap((Callable)this);
                            if (code != null) {
                                code.run(this);
                            }
                            break block56;
                        }
                        if (!this.cancelled.get()) {
                            if (allSync) {
                                this.call();
                                break block56;
                            } else {
                                this.svc.submit(this.scope.wrap((Callable)this));
                            }
                        }
                        break block56;
                    }
                    try (QuietAutoCloseable cl = this.scope.enter(this.state);){
                        this.onDone.onDone(newState, this.responses);
                    }
                }
                Void void_ = null;
                return void_;
            }
            catch (Error | Exception e) {
                this.onDone.onFailure(e);
                return null;
            }
        }

        @Override
        public void resume(Object ... addToContext) {
            if (this.cancelled.get()) {
                return;
            }
            if (this.deferred.compareAndSet(true, false)) {
                this.addToContext(addToContext);
                Callable<?> next = this.next;
                if (next != null) {
                    this.svc.submit(next);
                }
            } else {
                IllegalStateException ise = new IllegalStateException("Not deferred");
                if (this.deferral.stack != null) {
                    ise.addSuppressed(this.deferral.stack);
                }
            }
        }

        class DeferralImpl
        implements Deferral {
            Throwable stack;

            DeferralImpl() {
            }

            @Override
            public Deferral.Resumer defer() {
                if (ActeurInvoker.this.deferred.compareAndSet(false, true)) {
                    if (Boolean.getBoolean("acteur.debug")) {
                        this.stack = new Exception("Defer");
                    }
                    return ActeurInvoker.this;
                }
                if (this.stack != null) {
                    throw new IllegalStateException("Already deferred", this.stack);
                }
                throw new IllegalStateException("Already deferred");
            }

            @Override
            public Deferral.Resumer defer(Deferral.DeferredCode code) {
                if (ActeurInvoker.this.deferred.compareAndSet(false, true)) {
                    ActeurInvoker.this.deferredCode.set(code);
                    if (Boolean.getBoolean("acteur.debug")) {
                        this.stack = new Exception("Defer with code");
                    }
                    return ActeurInvoker.this;
                }
                if (this.stack != null) {
                    throw new IllegalStateException("Already deferred at", this.stack);
                }
                throw new IllegalStateException("Already deferred");
            }
        }
    }
}

