/*
 * Decompiled with CFR 0.152.
 */
package com.mastfrog.acteurbase;

import com.mastfrog.acteurbase.AbstractActeur;
import com.mastfrog.acteurbase.ActeurState;
import com.mastfrog.acteurbase.Chain;
import com.mastfrog.acteurbase.ChainCallback;
import com.mastfrog.acteurbase.ChainRunner;
import com.mastfrog.giulius.scope.ReentrantScope;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class ChainsRunner {
    private final ExecutorService svc;
    private final ReentrantScope scope;
    private final ChainRunner chainRunner;

    public ChainsRunner(ExecutorService svc, ReentrantScope scope, ChainRunner chainRunner) {
        this.svc = svc;
        this.scope = scope;
        this.chainRunner = chainRunner;
    }

    public ChainsRunner(ExecutorService svc, ReentrantScope scope) {
        this(svc, scope, new ChainRunner(svc, scope));
    }

    public <A extends AbstractActeur<T, R, S>, S extends ActeurState<T, R>, P extends Chain<? extends A, ?>, T, R extends T> void submit(Iterable<P> chains, ChainCallback<A, S, P, T, R> onDone, AtomicBoolean cancelled, Object ... initialContext) {
        this.svc.submit(this.scope.wrap(new OneChainRun<A, S, P, T, R>(this.svc, onDone, chains.iterator(), cancelled), initialContext));
    }

    class OneChainRun<A extends AbstractActeur<T, R, S>, S extends ActeurState<T, R>, P extends Chain<? extends A, ?>, T, R extends T>
    implements ChainCallback<A, S, P, T, R>,
    Callable<Void> {
        private final ExecutorService svc;
        private final ChainCallback<A, S, P, T, R> onDone;
        private final Iterator<P> iter;
        private final AtomicBoolean cancelled;

        public OneChainRun(ExecutorService svc, ChainCallback<A, S, P, T, R> onDone, Iterator<P> iter, AtomicBoolean cancelled) {
            this.svc = svc;
            this.onDone = onDone;
            this.iter = iter;
            this.cancelled = cancelled;
        }

        @Override
        public void onNoResponse() {
            boolean hasNext = this.iter.hasNext();
            if (!hasNext) {
                this.onDone.onNoResponse();
            } else {
                this.svc.submit(this);
            }
        }

        @Override
        public Void call() throws Exception {
            if (this.cancelled.get()) {
                return null;
            }
            try {
                boolean hasNext = this.iter.hasNext();
                if (!hasNext) {
                    this.onDone.onNoResponse();
                } else {
                    Chain c = (Chain)this.iter.next();
                    ChainsRunner.this.chainRunner.submit(c, this, this.cancelled);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public void onDone(S state, List<R> responses) {
            this.onDone.onDone(state, responses);
        }

        @Override
        public void onFailure(Throwable ex) {
            this.onDone.onFailure(ex);
        }

        @Override
        public void onRejected(S state) {
            this.onNoResponse();
        }

        @Override
        public void onBeforeRunOne(P chain) {
            this.onDone.onBeforeRunOne(chain);
        }

        @Override
        public void onBeforeRunOne(P chain, List<R> responsesThusFar) {
            this.onDone.onBeforeRunOne(chain, responsesThusFar);
        }

        @Override
        public void onAfterRunOne(P chain, A a) {
            this.onDone.onAfterRunOne(chain, a);
        }
    }
}

